% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_idea.R
\name{read_idea}
\alias{read_idea}
\title{Read IDEA4 items and metadata}
\usage{
read_idea(input)
}
\arguments{
\item{input}{a system path to the file containing the IDEA data.
The file extension can either be \code{json} or \code{xls(x)}. For the latter, the version number must be >= 4.2.0}
}
\value{
An object of class \code{IDEA_items} with two attributes :
\describe{
\item{metadata}{a named list containing the 17 metadata entries about the farm}
\item{items}{a tibble with the extracted 118 items found in the input}
}
}
\description{
Reads and imports items and farm metadata from .xls, .xlsx or .json files containing IDEA4 data.
}
\details{
This function is designed to import items and farm metadata from a single IDEA data file. Errors will be produced if the input file does not contain any "metadonnees" field in the case of a json file or any "Notice" sheet in the case of an excel file.

The R code has been developed according to the newest versions of IDEA data collecting files (version numbers >= 4.2.0)  and will produce an error if the version number is lower than 4.2.0 or can't be found in the 'Notice$K4' cell of the input in the case of excel input. There are no limitations for json input files as they were introduced after version number 4.2.0.

For some older versions (from about 2019-01-01), you can replace the " \code{read_idea() |>  compute_idea()} " pipeline by "\code{old_idea()}" which will focus on indicators rather than items.
}
\examples{
library(IDEATools)
path <- system.file("example_data/idea_example_1.json", package = "IDEATools")
my_data <- read_idea(path)
my_data
}
