% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta.typed.bootstrap}
\alias{get.theta.typed.bootstrap}
\title{runs bootstrapping on \code{get.theta.typed}}
\usage{
get.theta.typed.bootstrap(posmat, typeA = -1, typeB = -1, r = 1,
  r.low = rep(0, length(r)), boot.iter)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{typeA}{the "from" type that we are interested in, -1 is wildcard}

\item{typeB}{the "to" type that we are interested i, -1 is wildcard}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{boot.iter}{the number of bootstrap iterations}
}
\value{
theta values for all the distances we looked at
}
\description{
Bootstraps typed pi values. Makes sure distances between a sample and
another draw of itself are left out
}
\examples{
\dontrun{
 R/examples/get_theta_typed_bootstrap.R
 }

}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}},
  \code{\link{get.theta.ci}},
  \code{\link{get.theta.permute}},
  \code{\link{get.theta.typed.permute}},
  \code{\link{get.theta.typed}}, \code{\link{get.theta}}
}

