% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_add_pops.R
\name{data_add_pops}
\alias{data_add_pops}
\title{Add Population to IFC_data Object}
\source{
For pnt_in_poly_algorithm, Trigonometry, is an adaptation of Jeremy VanDerWal's code \url{https://github.com/jjvanderwal/SDMTools}
}
\usage{
data_add_pops(
  obj,
  pops,
  pnt_in_poly_algorithm = 1,
  pnt_in_poly_epsilon = 1e-12,
  display_progress = TRUE,
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{pops}{a list of population(s) to add to 'obj'. Each element of this list will be coerced by \code{\link{buildPopulation}}.}

\item{pnt_in_poly_algorithm}{algorithm used to determine if object belongs to a polygon region or not. Default is 1.\cr
Note that for the moment only 1(Trigonometry) is available.}

\item{pnt_in_poly_epsilon}{epsilon to determine if object belongs to a polygon region or not. It only applies when algorithm is 1. Default is 1e-12.}

\item{display_progress}{whether to display a progress bar. Default is TRUE.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with pops added.
}
\description{
Adds populations to an already existing `IFC_data` object.
}
\details{
A warning will be thrown if a provided population is already existing in 'obj'.\cr
In such a case this population will not be added to 'obj'.\cr
If any input population is not well defined and can't be created then an error will occur.
}
\examples{
if(requireNamespace("IFCdata", quietly = TRUE)) {
  ## use a daf file
  file_daf <- system.file("extdata", "example.daf", package = "IFCdata")
  daf <- ExtractFromDAF(fileName = file_daf)
  ## copy 1st population from existing daf
  pop <- daf$pops[[1]]
  if(length(pop) != 0) {
    pop_copy <- pop
    ## modify name, obj and type of copied population
    pop_copy$name <- paste0(pop_copy$name,"_copy")
    pop_copy$obj <- (which(pop_copy$obj)-1)[1]
    pop_copy$type <- "T"
    ## create new object with this new population
    dafnew <- data_add_pops(obj = daf, pops = list(pop_copy))
  }
} else {
  message(sprintf('Please run `install.packages("IFCdata", repos = "\%s", type = "source")` \%s',
                  'https://gitdemont.github.io/IFCdata/',
                  'to install extra files required to run this example.'))
}
}
