% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IGP_GPfit.R
\docType{class}
\name{IGP_sklearn}
\alias{IGP_sklearn}
\title{IGP R6 object for fitting sklearn model}
\format{\code{\link{R6Class}} object.}
\usage{
IGP_sklearn
}
\value{
Object of \code{\link{R6Class}} with methods for fitting GP model.
}
\description{
Class providing object with methods for fitting a GP model
}
\section{Fields}{

\describe{
\item{\code{X}}{Design matrix}

\item{\code{Z}}{Responses}

\item{\code{N}}{Number of data points}

\item{\code{D}}{Dimension of data}
}}

\section{Methods}{

\describe{
  \item{Documentation}{For full documentation of each method go to https://github.com/CollinErickson/IGP/}
  \item{\code{new(X=NULL, Z=NULL, package=NULL,
  estimate.nugget=T, nugget0=F, ...)}}{This method
  is used to create object of this class with \code{X} and \code{Z} as the data.
  The package tells it which package to fit the GP model.}
  \item{\code{update(Xall=NULL, Zall=NULL, Xnew=NULL, Znew=NULL, ...)}}{This method
  updates the model, adding new data if given, then running optimization again.}}
}

\examples{
\dontrun{
n <- 40
d <- 2
n2 <- 20
f1 <- function(x) {sin(2*pi*x[1]) + sin(2*pi*x[2])}
X1 <- matrix(runif(n*d),n,d)
Z1 <- apply(X1,1,f1) + rnorm(n, 0, 1e-3)
X2 <- matrix(runif(n2*d),n2,d)
Z2 <- apply(X2,1,f1)
XX1 <- matrix(runif(10),5,2)
ZZ1 <- apply(XX1, 1, f1)
u <- IGP_sklearn$new(X=X1,Z=Z1)
cbind(u$predict(XX1), ZZ1)
u$predict.se(XX1)
u$update(Xnew=X2,Znew=Z2)
u$predict(XX1)
u$delete()
}
}
\keyword{Gaussian}
\keyword{data,}
\keyword{kriging,}
\keyword{process,}
\keyword{regression}
