% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{model_selection}
\alias{model_selection}
\title{Model Selection}
\usage{
model_selection(
  loglik,
  n,
  g = 4,
  d = 2,
  modelname = c("IMIX_ind", "IMIX_ind_unrestrict", "IMIX_cor_twostep", "IMIX_cor",
    "IMIX_cor_restrict")
)
}
\arguments{
\item{loglik}{Full log likelihood, result output from IMIX or a sub model in IMIX: `Full MaxLogLik final`}

\item{n}{Total number of genes}

\item{g}{Number of components}

\item{d}{Number of data types}

\item{modelname}{The model name, default is IMIX_ind}
}
\value{
AIC/BIC values of the target model
}
\description{
Model selection for sub-model outputs in IMIX, this step is to calculate the AIC or BIC values for one model
}
\examples{
\donttest{
# First load the data
data("data_p")

# Specify the initial values
mu_input <- c(0,3,0,3)
sigma_input <- rep(1,4)
p_input <- rep(0.5,4)

# Fit the IMIX model
test1 <- IMIX(data_input = data_p,data_type = "p",mu_ini = mu_input,sigma_ini = sigma_input,
p_ini = p_input,alpha = 0.1,model_selection_method = "AIC")

# Calculate the AIC and BIC values for IMIX_ind with two data types and four components
model_selection(test1$IMIX_ind$`Full MaxLogLik final`,
n=dim(test1$IMIX_ind$`posterior prob`)[1],g=4,d=2, "IMIX_ind")
}
}
\references{
Ziqiao Wang and Peng Wei. 2020. “IMIX: a multivariate mixture model approach to association analysis through multi-omics data integration.” Bioinformatics. \url{https://doi.org/10.1093/bioinformatics/btaa1001}.
}
