% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumps2.R
\name{jumps2}
\alias{jumps2}
\title{Labels interdiurnal large differences}
\usage{
jumps2(date, value, quanty = 0.999, times = 1, force = NULL)
}
\arguments{
\item{date}{vector of dates}

\item{value}{vector of values}

\item{quanty}{numeric value (quantile of the differences) used to aggregate daily differences}

\item{times}{factor to multiply the quantile value}

\item{force}{value of threshold for daily value differences to be forced}
}
\value{
list of positions which do not pass this QC test
}
\description{
This function labels interdiurnal differences considered too large
}
\examples{
#Extract the ECA&D data file from the example data folder
path2inptfl<-system.file("extdata", "TX_SOUID132734.txt", package = "INQC")
#Read the data file
date<-readecad(input=path2inptfl,missing= -9999)[,3]
value<-readecad(input=path2inptfl,missing= -9999)[,4]
#Find all suspicious positions in the time series
jumps2(date,value,quanty=0.999,times=1)

#Find all suspicious positions in the time series
jumps2(date,value,force=100)
}
