% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.RT.Parameters}
\alias{Plot.RT.Parameters}
\alias{Plot.RT.Parameters.DataSetList}
\title{Plot the parameter values recorded in a DataSetList (aligned by funcion value)}
\usage{
Plot.RT.Parameters(dsList, f_min = NULL, f_max = NULL,
  algids = "all", par_name = NULL, scale.xlog = F, scale.ylog = F,
  show.mean = T, show.median = F, show.CI = F)

\method{Plot.RT.Parameters}{DataSetList}(dsList, f_min = NULL,
  f_max = NULL, algids = "all", par_name = NULL, scale.xlog = F,
  scale.ylog = F, show.mean = T, show.median = F, show.CI = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{f_min}{The starting function value.}

\item{f_max}{The final function value.}

\item{algids}{Which algorithms from dsList to use}

\item{par_name}{Which parameters to create plots for; set to NULL to use all
parameters found in dsList.}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}

\item{scale.ylog}{Whether or not to scale the y-axis logaritmically}

\item{show.mean}{Whether or not to show the mean parameter values}

\item{show.median}{Whether or not to show the median parameter values}

\item{show.CI}{Whether or not to show the standard deviation}
}
\value{
A plot of for every recorded parameter in the DataSetList
}
\description{
Plot the parameter values recorded in a DataSetList (aligned by funcion value)
}
\examples{
Plot.RT.Parameters(subset(dsl, funcId == 1))
}
