% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.plots.R
\name{save.plots}
\alias{save.plots}
\title{Workflow to generate HTML files for all kinds of plots}
\usage{
save.plots(output.dir)
}
\arguments{
\item{output.dir}{A result directory as the \code{$output} object returned
from the \code{\link{ipcaps}} function.}
}
\value{
\code{NULL}
}
\description{
Generate HTML files and all image files (plots) from the result
of \code{\link{ipcaps}}. The clustering result is shown as a tree rendering
by the online Google Organizational Chart library. Note that the Internet is
required to view the HTML files.
}
\details{
After running, this function generates all plots and saves as image files in the
sub-directory 'images'. It calls \code{\link{save.plots.cluster.html}},
\code{\link{save.eigenplots.html}}, and \code{\link{save.plots.label.html}}
to generate all HTML files.
}
\examples{

# Importantly, bed file, bim file, and fam file are required
# Use the example files embedded in the package

\donttest{
BED.file <- system.file("extdata","IPCAPS_example.bed",package="IPCAPS")
LABEL.file <- system.file("extdata","IPCAPS_example_individuals.txt",package="IPCAPS")

my.cluster <- ipcaps(bed=BED.file,label.file=LABEL.file,lab.col=2,out=tempdir())

#Here, to generate all plots and HTML files
save.plots.label.html(my.cluster$output.dir)
}
}
\seealso{
\code{\link{save.html}},
\code{\link{save.plots.cluster.html}},
\code{\link{save.eigenplots.html}},
and \code{\link{save.plots.label.html}}
}
