% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.gamete.R
\name{simu.gamete}
\alias{simu.gamete}
\title{Simulate The Genotypic Values Of A Gamete}
\usage{
simu.gamete(marker)
}
\arguments{
\item{marker}{data frame. A p*4 data frame whose first column indicates the
chromosome number to which a marker belongs; second column indicates the
position of the marker in centi-Morgan (cM); and 3rd and 4th columns
indicates the genotype of the marker (numeric or character).}
}
\value{
The SNP sequence of gamete.
}
\description{
Generate the genotypic values of a gamete from the genotypic data of its
parents by Monte Carlo simulation. The recombination rate is caculate by
Haldane’s mapping function.
}
\examples{
# generate simulated data
marker.test <- data.frame(c(1,1,1,1,1,2,2,2,2,2),c(10,20,30,40,50,10,20,30,40,50),
c("A","T","C","G","A","A","G","A","T","A"),c("A","A","G","C","T","A","G","T","T","A"))

# run
simu.gamete(marker.test)
}
\references{
Haldane J.B.S. 1919. The combination of linkage values and the calculation
of distance between the loci for linked factors. Genetics 8: 299–309.
}
