% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipv_est.R
\name{ipv_est}
\alias{ipv_est}
\title{IPV estimation}
\usage{
ipv_est(
  dat,
  name,
  estimator = "ML",
  include_raw = TRUE,
  include_lav = TRUE,
  include_xarrow = TRUE
)
}
\arguments{
\item{dat}{data frame; raw data (see details)}

\item{name}{character; name of the overall construct or test that comprises
all items used}

\item{estimator}{character; estimator used by lavaan; defaults to "ML"
(Maximum Likelihood)}

\item{include_raw}{logical; should raw estimates of factor loadings be
included in the output?; defaults to TRUE}

\item{include_lav}{logical; should lavaan objects of the fitted models be
included in the output?; defaults to TRUE}

\item{include_xarrow}{logical; should an object for the drawing of arrows in
nested plots be returned?; defaults to TRUE}
}
\value{
list; \code{$est} includes the center distances and all necessary
  input for the IPV chart functions, \code{$est_raw} includes the factor
  loadings and latent correlations, \code{$lav} includes the fitted models
  (class: \code{lavaan}), \code{$xarrow} includes a data frame for arrows
  between facets in nested charts, that can be passed on directly to
  \code{nested_chart}; by default, all three of these elements are provided.

  \code{$xarrow} includes only those cases, where the estimate of the latent
  correlation between facets exceeds the estimate of the latent correlation
  between their respective tests, as recommended by the original authors.
}
\description{
IPV estimation
}
\details{
the data given to \code{dat} have to conform to the following rules:
  * no additional variables / columns * variables are named according to the
  following pattern: \code{"test_facet_item"}. * If there is only one test in
  the data, the pattern is "facet_item". For tests without facets in a larger
  dataset also comprising tests with items, the pattern is "test_item". *
  Variable names have to be unique. Item names have to be unique at the level
  of the test (not only at the level of the facet) See example
}
\examples{
# an IPV that comprises the honesty/humility and the agreeableness factor of
# the HEXACO (reduced to first 4 items per facet and first 1000 observations
# to reduce runtime)
res <- ipv_est(
  HEXACO[1:500, grep("^H_.*[1-4]$|^A_.*[1-4]$", names(HEXACO))],
  "HA")
nested_chart(res$est)
}
