% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_score.R
\name{factor_score}
\alias{factor_score}
\title{Estimated factor scores}
\usage{
factor_score(x, ability_method = "EAP")
}
\arguments{
\item{x}{A model fit object from either \code{IRTest_Dich}, \code{IRTest_Poly}, or \code{IRTest_Mix}.}

\item{ability_method}{The ability parameter estimation method.
The available options are Expected \emph{a posteriori} (\code{EAP}) and Maximum Likelihood Estimates (\code{MLE}).
The default is \code{EAP}.}
}
\value{
\item{theta}{The estimated ability parameter values. If \code{ability_method = "MLE"}.
If an examinee receives a maximum or minimum score for all items, the function returns \eqn{\pm}\code{Inf}.}
\item{theta_se}{The asymptotic standard errors of ability parameter estimates. Available only when \code{ability_method = "MLE"}.
If an examinee receives a maximum or minimum score for all items, the function returns \code{NA}.}
}
\description{
Factor scores of examinees.
}
\examples{
\donttest{
# A preparation of dichotomous item response data

data <- DataGeneration(N=500, nitem_D = 10)$data_D

# Analysis

M1 <- IRTest_Dich(data)

# Item fit statistics

factor_score(M1, ability_method = "MLE")
}
}
\author{
Seewoo Li \email{cu@yonsei.ac.kr}
}
