% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{probability.2pl}
\alias{probability.2pl}
\title{2PL probability function}
\usage{
probability.2pl(z, a = z$a, b = z$b, theta, d = -a * b)
}
\arguments{
\item{z}{Optional. A list with the parameters a and b specified by keys.}

\item{a}{The discrimination parameter}

\item{b}{The difficulty parameter. (Optional if d is specified)}

\item{theta}{The subject's latent trait.}

\item{d}{Optional. Overrides the b parameter, it is equal to -a*b. Used in some functions.}
}
\value{
Tue value of the probability for the model 2pl.
}
\description{
The probability function in the 2PL model.
}
\examples{
## Simulate the test
# data <- simulateTest(model = "2PL", items = 20, individuals = 200)
## item parameters
# zita <-data$itempars
## Latent traits
# thetas <- data$latentTraits
## Probability model
# probability.2pl(zita, theta = thetas)
}
\seealso{
\code{\link{probability.1pl}}, \code{\link{probability.3pl}}, 
\code{\link{prob.3pl}}, \code{\link{prob.2pl}}
}

