% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulateTest}
\alias{simulateTest}
\title{Simulates a test}
\usage{
simulateTest(model = "3PL", items = 10, latentTraits = NULL,
  individuals = 1000, boundaries = NULL, dims = 1, itempars = NULL,
  verbose = F, threshold = 0, seed = 500L, clusters = NULL,
  repetition = 1)
}
\arguments{
\item{model}{The IRT model. "1PL","2PL" or "3PL". In Multidimensional is "3PL".}

\item{items}{The items to simulate in the test.}

\item{latentTraits}{The latentTraits in the UIRT case.}

\item{individuals}{The individuals to simulate in the test.}

\item{boundaries}{The boundaries for parameter generation. See the \code{\link{simulateItemParameters}} documentation for help.}

\item{dims}{The dimensionality of the test.}

\item{itempars}{A list with teh parameters of the items if provided.}

\item{verbose}{Verbosibity for more information about the process, use when simulating long tests.}

\item{threshold}{A boundary for the percent of answered questions to a test. i.e. 0.05 indicates the individuals will answer maximum the 95\% of the questions and minimum the 5\% of the questions. UIRT only.}

\item{seed}{Desired seed to use in test generation. If null, a seed based on the current time will be used.}

\item{clusters}{Used for MD test generation.}

\item{repetition}{Used for MD test generation.}
}
\value{
List with model, seed, itempars, and the simulated test.
}
\description{
Simulates a test according to a IRT Model.
}
\details{
Check the documentation of \code{\link{simulateTestMD}} for information
on the return in the Multidimensional case.
}
\examples{
# simulateTest("2PL", items = 30, individuals = 500)
}
\seealso{
\code{\link{simulateTest.file}}, \code{\link{simulateTestMD}}
}

