#' Survey results data set
#'
#' Synthetic survey data from a community college used to illustrate survey non-response/response bias and methods to reduce this bias.  This data set (\code{survey_results}) contains responses to some of the student satisfaction survey questions.  For a list of students invited to participate in the survey, as well information on which students responded to the survey, see the \code{\link{survey_response}} data set.
#' @format A data frame with responses to a student satisfaction survey.  For questions with Likert scale responses and asking about satisfaction, the options are \code{Very Dissatisfied}, \code{Somewhat Dissatisfied}, \code{Somewhat Satisfied}, or \code{Very Satisfied}.
#' \describe{
#'   \item{Email_Masked}{student's masked email address, also serving as the student's unique identifier.}
#'   \item{Overall Satisfaction}{(Likert scale) Student's overall satsfaction at the college.}
#'   \item{Classroom learning experience}{(Likert scale) Student's satisfaction with classroom learning.}
#'   \item{Your ability to register for classes you want/need}{(Likert scale) Student's satisfaction with the ability to register for classes.}
#'   \item{Variety of courses offered}{(Likert scale) Student's satisfaction with variety of courses offered.}
#'   \item{Class size (number of students in a class)}{(Likert scale) Student's satisfaction with class size.}
#'   \item{Campus safety/security}{(Likert scale) Student's satisfaction with campus safety.}
#'   \item{Financial Aid Office}{(Likert scale) Student's satisfaction with the Financial Aid Office.}
#'   \item{Tutoring Services}{(Likert scale) Student's satisfaction with Tutoring Services.}
#'   \item{Selecting a major}{(Likert scale) Student's reported difficulty in selecting a major at the college.  The options are \code{Very Difficult}, \code{Somewhat Difficult}, \code{Somewhat Easy}, and \code{Very Easy}}
#'   \item{Canvas}{(Likert scale) Student's satisfaction with Canvas, the college's online learning management system.}
#'   \item{Have you heard about the new California Initiative called Guided Pathways?}{(Binary) 1 (Yes) or 0 (No)}
#' }
#' @docType data
#' 
#' @usage data(survey_results)
#'
#' @keywords datasets
#'
#' @examples
#' data(survey_results)
"survey_results"
