% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVPP.R
\name{IVPP_panelgvar}
\alias{IVPP_panelgvar}
\title{The invariance partial pruning (IVPP) algorithm for panel GVAR models}
\usage{
IVPP_panelgvar(
  data,
  vars,
  idvar,
  beepvar,
  groups,
  test = c("both", "temporal", "contemporaneous"),
  net_type = c("saturated", "sparse"),
  partial_prune = FALSE,
  prune_net = c("both", "temporal", "contemporaneous"),
  prune_alpha = 0.01,
  p_prune_alpha = 0.01,
  estimator = "FIML",
  standardize = c("none", "z", "quantile"),
  ...
)
}
\arguments{
\item{data}{A data frame containing the long-formatted panel data}

\item{vars}{A character vector of variable names}

\item{idvar}{A character string specifying subject IDs}

\item{beepvar}{A character string specifying the name of wave (time) variable}

\item{groups}{A character string specifying the name of group variable}

\item{test}{A character vector specifying the network you want to test group-equality on in the global invariance test.
Specify "both" if you want to test on both temporal or contemporaneous networks.
Specify "temporal" if you want to test only on the temporal network.
Specify "contemporaneous" if you want to test only on the contemporaneous network.
See the Details section for more information.}

\item{net_type}{A character vector specifying the type of networks to be compared in the global test.
Specify "saturated" if you want to estimate and compare the saturated networks.
Specify "sparse" if you want to estimate and compare the pruned networks.}

\item{partial_prune}{A logical value specifying whether to conduct partial pruning test or not.}

\item{prune_net}{A character vector specifying the network you want to partial prune on. Only works when partial_prune = TRUE.}

\item{prune_alpha}{A numeric value specifying the alpha level for the pruning (if net_type = "sparse").}

\item{p_prune_alpha}{A numeric value specifying the alpha level for the partial pruning (if partial_prune = TRUE).}

\item{estimator}{A character string specifying the estimator to be used. Must be "FIML"}

\item{standardize}{A character string specifying the type of standardization to be used.
"none" (default) for no standardization, "z" for z-scores,
and "quantile" for a non-parametric transformation to the quantiles of the marginal standard normal distribution.}

\item{...}{Additional arguments to be passed to the \code{\link[psychonetrics]{dlvm1}} function}
}
\value{
A list containing the results of IVPP and networks of all groups.
}
\description{
This function implements the IVPP algorithm to compare networks in the multi-group panelGVAR models.
The IVPP algorithm is a two-step procedure that first conducts an global invariance test of network difference and then performs partial pruning for the specific edge-level differences.
Currently supports the comparison of temporal and contemporaneous networks.
}
\details{
The comparison between the fully unconstrained (free) model and tempEq model is a test for group equality in temporal networks.
The comparison between fully constrained model (bothEq) and tempEq is a test for group equality in contemporaneous networks.
Similarly, the comparison between the free model and contEq model is a test for group equality in contemporaneous networks,
and the comparison between bothEq and contEq is a test for group equality in temporal networks.
}
\examples{
\donttest{
# Generate the network
net_ls <- gen_panelGVAR(n_node = 6,
                        p_rewire = 0.5,
                        n_group = 2)

# Generate the data
data <- sim_panelGVAR(temp_base_ls = net_ls$temporal,
                      cont_base_ls = net_ls$omega_zeta_within,
                      n_person = 250,
                      n_time = 3,
                      n_group = 2,
                      n_node = 6)

# IVPP test on the temporal network
ivpp <- IVPP_panelgvar(data,
                       vars = paste0("V",1:6),
                       idvar = "subject",
                       beepvar = "time",
                       groups = "group",
                       test = "temporal",
                       net_type = "saturated",
                       prune_net = "temporal",
                       partial_prune = TRUE,
                       estimator = "FIML",
                       standardize = "z")
}
}
