#' List of information about each region
#'
#' A region information list, \code{reg_info}, is a list of ten items
#' \code{regions},\code{start_lines}, \code{start_lines_coords},
#' \code{start_coords}, \code{end_coords}, \code{out}, \code{lines}, \code{dist},
#' \code{loop}, and \code{angs}. The package contains a \code{reg_info} object
#' which is typically what is used for all analyses. However, it would be
#' possible to redefine the regions if desired by making a new \code{reg_info}
#' object.
#'
#'
#' \code{regions}: list of \code{SpatialPolygons} objects corresponding
#' to each region.
#'
#' \code{start_lines}: list of \code{SpatialLines} object giving the line from
#' which each mapping or contour generation will start. For the central Arctic
#' region, a single \code{SpatialPoint} is used instead. List ordered the same
#' as \code{reg_info$regions}
#'
#' \code{start_lines_coords}: list of matrices giving the coordinates that
#' approximately match \code{reg_info$start_lines}, except that they extend to
#' touch the end point of the first and last fixed line. For the central Arctic
#' region, the coordinate of the \code{start_line}is just repeated. List ordered
#' the same as \code{reg_info$regions}
#'
#' \code{start_coords}: list of matrices giving the coordinates from which the
#' lines start. List ordered the same as \code{reg_info$regions}
#'
#' \code{end_coords}: list of matrices giving the coordinates between the end
#' points of the first and last fixed line. List ordered the same as
#' \code{reg_info$regions}
#'
#' \code{out}: list of \code{SpatialPolygons} object that border
#' \code{reg_info$start_lines}, but are outside the region. These are used when
#' building new polygons to determine if points are outside the region of
#' interest. List ordered the same as \code{reg_info$regions}
#'
#' \code{lines}: list giving the \code{SpatialLines} objects that correspond to
#' the line on which contours are mapped and built.
#'
#' \code{dist}: list for each region with one item for each line
#' \code{reg_info$lines} giving the lengths at which restrictions on the line
#' lengths occur. The first element for all entries is 0 and the last element
#' is the length of the line. Elements in between refer to the starting and
#' ending lengths on which points cannot be placed. The first list index is
#' ordered the same as \code{reg_info$regions} and the second list index is
#' ordered as the corresponding lines in \code{reg_info$lines}
#'
#' \code{loop}: vector gives a Boolean for each region. The value \code{TRUE}
#'  indicates that the \code{lines} are mapped in a circle around a fixed point.
#'  The value \code{FALSE} indicates that the lines are mapped along a line on
#'  land. The first element, corresponding to the central Arctic region is
#'  \code{TRUE}. All others are \code{FALSE}. Elements ordered the same as
#'  \code{reg_info$regions}
#'
#'  \code{angs}: list of vectors giving the angles of the corresponding
#'  \code{reg_info$lines}. Elements ordered the same as \code{reg_info$regions}
#'
#' @keywords datasets
#' @docType data
#' @references  The regions in this object have been substantially modified from
#'              the following region mask:
#'
#'              National Snow and Ice Data Center, 2017: Region mask for the
#'              northern hemisphere
#'              \url{http://nsidc.org/data/polar-stereo/tools_masks.html}.
#'
#' @examples
#' data(reg_info)
#' names(reg_info)
"reg_info"
