% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importExport.R
\name{quick_run}
\alias{quick_run}
\title{Simple evaluation of contour-shifting}
\usage{
quick_run(obs_NCDF, pred_NCDF, pred_years, start_year, month, output_file,
  level, dat_type_obs = "bootstrap", n_train_years = NULL)
}
\arguments{
\item{obs_NCDF}{filepath for observed data array (see details for info about
array structure)}

\item{pred_NCDF}{filepath for predicted data array (see details for info about
array structure)}

\item{pred_years}{vectors of years for which to make prediction}

\item{start_year}{first year to use when learning model}

\item{month}{month of prediction}

\item{output_file}{filepath for where bias-corrected netCDF file should be
stored}

\item{level}{concentration level for which to build contour}

\item{dat_type_obs}{string of either "bootstrap" or "simple" indicating the
file type of the observation (see details for info about
array structure)}

\item{n_train_years}{number of prior years used in training bias correction}
}
\value{
netCDF file of dimension years by longitude (304) by latitude (448)
        with indicators for where ice is predicted after bias correction.
        (1: ice-covered, 0: not ice, NA: land). Grid boxes will be
        categorized as ice if their centers are ice covered (within R the
        bias-corrected contours are not restricted to align to a grid).
}
\description{
Reads in netCDF files of observations and predictions, performs bias
correction, and exports a new netCDF file with bias-corrected predictions
}
\details{
The predicted data array, \code{pred_NCDF}, should be a netCDF file
         with a single array of dimension: years x longitude (304) x
         latitude (448). The variable should be named \code{ice_ind}. The
         values in the array should indicate whether each grid box is
         categorized to contain ice (1: ice-covered, 0: no ice, NA: land).
         The observed data array, \code{obs_NCDF}, should be a netCDF file
         with a single array of dimension: years x longitude (304) x
         latitude (448). The observed data array, \code{obs_NCDF}, can be
         formatted the same as \code{pred_NCDF} if
         \code{dat_type_obs = "simple"}. Alternatively, if
         \code{dat_type_obs = "bootstrap"} the array values can be ice
         concentration values obtained from the National Aeronautics and Space
         Administration (NASA) satellites Nimbus-7 SMMR and DMSP SSM/I-SSMIS
         and processed by the bootstrap algorithm. Data should be retained in
         the same format as given by bootstrap (including indicators for
         missing data, land etc.). The variable should be named "conc".
}
\examples{
\dontrun{
quick_run(obs_NCDF = "/obs.nc", pred_NCDF = "/pred.nc",
         pred_years = c(2001:2013), start_year = 1980, month = 2,
         output_file = "/outputFile.nc", level = 15, dat_type_obs = "simple")
}
}
\references{
Comiso, J., 2017: Bootstrap sea ice concentrations
            from Nimbus-7 SMMR and DMSP SSM/I-SSMIS. version 3.
            {Boulder, Colorado USA: NASA National Snow and Ice Data Center
            Distributed Active Archive Center}
}
