\name{ReadIgorPackedExperiment}
\alias{ReadIgorPackedExperiment}
\title{Reads an Igor Pro Packed Experiment (.pxp) file}
\usage{
  ReadIgorPackedExperiment(pxpfile, Verbose = FALSE,
    StructureOnly = FALSE, regex, ...)
}
\arguments{
  \item{pxpfile}{Character vector naming a PXP file or an R
  \link{connection}}

  \item{Verbose}{whether to print information to console
  during loading (numeric values are also allowed 0=none,
  1=basic, 2=all)}

  \item{StructureOnly}{TODO Only the structure of the pxp
  file for inspection}

  \item{regex}{only read records (e.g. waves) in the pxp
  file whose names match a \link{regex}}

  \item{...}{Optional parameters passed to
  \link{ReadIgorBinary}}
}
\value{
  A list containing all the individual waves or variables
  in the pxp file
}
\description{
  Note that pxp files are only partially documented so some
  contents cannot be parsed (e.g. image data). Furthermore
  for the time being this function only reads data records
  (Igor waves and variables) but ignores e.g. history,
  program code etc.
}
\examples{
r=ReadIgorPackedExperiment(system.file("igor","testexpt.pxp",package="IgorR"))
}
\author{
  jefferis
}

