/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.Former;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tobject.ObjectFactory2D;
import cern.colt.matrix.tobject.algo.ObjectFormatter;

public class LongFormatter
extends AbstractFormatter {
    private static final long serialVersionUID = 1L;

    public LongFormatter() {
        this("%d");
    }

    public LongFormatter(String string) {
        this.setFormat(string);
        this.setAlignment("decimal");
    }

    protected String form(LongMatrix1D longMatrix1D, int n, Former former) {
        return former.form(longMatrix1D.get(n));
    }

    protected String form(AbstractMatrix1D abstractMatrix1D, int n, Former former) {
        return this.form((LongMatrix1D)abstractMatrix1D, n, former);
    }

    public String[][] format(LongMatrix2D longMatrix2D) {
        String[][] stringArray = new String[longMatrix2D.rows()][longMatrix2D.columns()];
        int n = longMatrix2D.rows();
        while (--n >= 0) {
            stringArray[n] = this.formatRow(longMatrix2D.viewRow(n));
        }
        return stringArray;
    }

    protected String[][] format(AbstractMatrix2D abstractMatrix2D) {
        return this.format((LongMatrix2D)abstractMatrix2D);
    }

    protected int indexOfDecimalPoint(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            n = string.lastIndexOf(101);
        }
        if (n < 0) {
            n = string.lastIndexOf(69);
        }
        if (n < 0) {
            n = string.length();
        }
        return n;
    }

    protected int lead(String string) {
        if (this.alignment.equals("decimal")) {
            return this.indexOfDecimalPoint(string);
        }
        return super.lead(string);
    }

    public String toSourceCode(LongMatrix1D longMatrix1D) {
        LongFormatter longFormatter = (LongFormatter)this.clone();
        longFormatter.setPrintShape(false);
        longFormatter.setColumnSeparator(", ");
        String string = "{";
        String string2 = "};";
        return string + longFormatter.toString(longMatrix1D) + string2;
    }

    public String toSourceCode(LongMatrix2D longMatrix2D) {
        LongFormatter longFormatter = (LongFormatter)this.clone();
        String string = this.blanks(3);
        longFormatter.setPrintShape(false);
        longFormatter.setColumnSeparator(", ");
        longFormatter.setRowSeparator("},\n" + string + "{");
        String string2 = "{\n" + string + "{";
        String string3 = "}\n};";
        return string2 + longFormatter.toString(longMatrix2D) + string3;
    }

    public String toSourceCode(LongMatrix3D longMatrix3D) {
        LongFormatter longFormatter = (LongFormatter)this.clone();
        String string = this.blanks(3);
        String string2 = this.blanks(6);
        longFormatter.setPrintShape(false);
        longFormatter.setColumnSeparator(", ");
        longFormatter.setRowSeparator("},\n" + string2 + "{");
        longFormatter.setSliceSeparator("}\n" + string + "},\n" + string + "{\n" + string2 + "{");
        String string3 = "{\n" + string + "{\n" + string2 + "{";
        String string4 = "}\n" + string + "}\n}";
        return string3 + longFormatter.toString(longMatrix3D) + string4;
    }

    public String toString(LongMatrix1D longMatrix1D) {
        LongMatrix2D longMatrix2D = longMatrix1D.like2D(1, (int)longMatrix1D.size());
        longMatrix2D.viewRow(0).assign(longMatrix1D);
        return this.toString(longMatrix2D);
    }

    public String toString(LongMatrix2D longMatrix2D) {
        return super.toString(longMatrix2D);
    }

    public String toString(LongMatrix3D longMatrix3D) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.printShape;
        this.printShape = false;
        for (int i = 0; i < longMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toString(longMatrix3D.viewSlice(i)));
        }
        this.printShape = bl;
        if (this.printShape) {
            stringBuffer.insert(0, LongFormatter.shape(longMatrix3D) + "\n");
        }
        return stringBuffer.toString();
    }

    protected String toString(AbstractMatrix2D abstractMatrix2D) {
        return this.toString((LongMatrix2D)abstractMatrix2D);
    }

    protected String toTitleString(LongMatrix2D longMatrix2D, String[] stringArray, String[] stringArray2, String string, String string2, String string3) {
        if (longMatrix2D.size() == 0L) {
            return "Empty matrix";
        }
        Object[][] objectArray = this.format(longMatrix2D);
        this.align((String[][])objectArray);
        return new ObjectFormatter().toTitleString(ObjectFactory2D.dense.make(objectArray), stringArray, stringArray2, string, string2, string3);
    }

    private String xtoTitleString(LongMatrix3D longMatrix3D, String[] stringArray, String[] stringArray2, String[] stringArray3, String string, String string2, String string3, String string4) {
        if (longMatrix3D.size() == 0L) {
            return "Empty matrix";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < longMatrix3D.slices(); ++i) {
            if (i != 0) {
                stringBuffer.append(this.sliceSeparator);
            }
            stringBuffer.append(this.toTitleString(longMatrix3D.viewSlice(i), stringArray2, stringArray3, string2, string3, string4 + "\n" + string + "=" + stringArray[i]));
        }
        return stringBuffer.toString();
    }
}

