% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIncucyteDRCSet.R
\name{plotIncucyteDRCSet}
\alias{plotIncucyteDRCSet}
\title{plotIncucyteDRCSet}
\usage{
plotIncucyteDRCSet(idrc_set, grouped = FALSE)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}

\item{grouped}{Boolean - whether the curves should be grouped or not.}
}
\value{
ggplot object
}
\description{
Plot the growth curve data from an IncucyteDRCSet object
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])
test_idrc_set <- fitGrowthCurvesIndividual(test_idrc_set)
plotIncucyteDRCSet(test_idrc_set, grouped=FALSE)
plotIncucyteDRCSet(test_idrc_set, grouped=TRUE)

}

