% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_abov_below_mean.R
\name{normalization_abov_below_mean}
\alias{normalization_abov_below_mean}
\title{Normalization above or below the mean}
\usage{
normalization_abov_below_mean(data, p = 0.01)
}
\arguments{
\item{data}{dataframe with rows = observations and columns = quantiative
variables}

\item{p}{threshold for the window}
}
\value{
It returns a datafame of normalized data
}
\description{
This transformation considers the indicators which are above and below an
arbitrarily defined threshold, p, around the mean. The threshold p builds a
neutral region around the mean, where the transformed indicator is zero.
This reduces the sharp discontinuity, from -1 to +1, which exists across the
mean value to two minor discontinuities, from -1 to 0 and from 0 to +1,
across the thresholds
}
\details{
This function to normalize in -1, 0, and 1
}
\examples{

data("Education")
Indicator=normalization_abov_below_mean(Education)
print(Indicator)

#---With different threshold
Indicator=normalization_abov_below_mean(Education,p=0.1)
print(Indicator)


}
\references{
OECD/European Union/EC-JRC (2008), Handbook on Constructing
Composite Indicators: Methodology and User Guide, OECD Publishing, Paris,
<https://doi.org/10.1787/9789264043466-en>
}
\keyword{above}
\keyword{and}
\keyword{below}
\keyword{mean}
\keyword{normalization}
