% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteRD.R
\name{Ref_free}
\alias{Ref_free}
\title{A reference-free deconvolution estimate}
\usage{
Ref_free(bulk.data,list_marker,cell_type_unique,tol=0.001)
}
\arguments{
\item{bulk.data}{The `ExpressionSet` object for a target bulk data.}

\item{list_marker}{A list of pre-specified marker genes corresponding to each cell type.}

\item{cell_type_unique}{A list of cell types. It should match the order in `list.marker`.}

\item{tol}{A tolerance value for convergence. The default is 0.001.}
}
\value{
The estimated cell type proportions, named `est`; and a goodness-of-fit value, named `metrics`. The smaller the better.
}
\description{
This function provides a reference-free deconvolution estimate, given a list of marker genes
}
\examples{
##read data
library(InteRD)
readRDSFromWeb<-function(ref) {readRDS(gzcon(url(ref)))}
urlremote<-"https://github.com/chencxxy28/Data/raw/main/data_InteRD/"
pseudo.seger<-readRDSFromWeb(paste0(urlremote,"pseudo.seger.rds"))
list_marker<-readRDSFromWeb(paste0(urlremote,"list_markerbaron20.rds"))
cell_type_unique<-c("alpha","beta","delta","gamma")
ref_free.output<-Ref_free(bulk.data=pseudo.seger,list_marker=list_marker,
cell_type_unique=cell_type_unique,tol=0.01) #make tol=0.001
reffree<-InteRD.predict.prop(InteRD.output=ref_free.output)

}
