% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSpec.R
\name{PlotSpec}
\alias{PlotSpec}
\title{Plot Mass Spectrum.}
\usage{
PlotSpec(x = NULL, masslab = 0.1, rellab = FALSE, cutoff = 0.01,
  cols = NULL, txt = NULL, mz_prec = 4, neutral_losses = NULL,
  neutral_loss_cutoff = 0.5)
}
\arguments{
\item{x}{A two-column matrix with ("mz", "int") information.}

\item{masslab}{The cutoff value  (relative to basepeak) for text annotation of peaks.}

\item{rellab}{TRUE/FALSE. Label masses relative to largest mass in plot (if TRUE), absolute (if FALSE) or to specified mass (if numeric).}

\item{cutoff}{Show only peaks with intensity higher than cutoff*I(base peak). This will limit the x-axis accordingly.}

\item{cols}{Color vector for peaks with length(cols)==nrow(x).}

\item{txt}{Label peaks with specified text (column 1 specifies x-axis value, column 2 specifies label).}

\item{mz_prec}{Numeric precision of m/z (=number of digits to plot).}

\item{neutral_losses}{Data frame of defined building blocks (Name, Formula, Mass). If not provided data("neutral_losses") will be used.}

\item{neutral_loss_cutoff}{Specifies the allowed deviation in mDa for neutral losses to be accepted from the provided neutral loss list.}
}
\value{
An annotated plot of the mass spectrum.
}
\description{
\code{PlotSpec} will read, evaluate and plot a deconvoluted mass spectrum (mass*intensity pairs) from TMS-derivatized GC-APCI-MS data. 
The main purpose is to visualize the relation between deconvoluted masses.
}
\examples{
#load test data and apply function
utils::data(test_spectrum)
PlotSpec(x=test_spectrum)

# normalize test data by intensity
s <- test_spectrum
s[,2] <- s[,2]/max(s[,2])
PlotSpec(x=s)

# use more stringent cutoff
PlotSpec(x=s, cutoff=0.1)

# use relative labelling
PlotSpec(x=s, cutoff=0.1, rellab=364.1789)

# avoid annotation of masses and fragments
PlotSpec(x=s, masslab=NULL, neutral_losses=NA)

# provide individual neutral loss set
tmp <- data.frame("Name"=c("Loss1","Loss2"),"Formula"=c("",""),"Mass"=c(90.05,27.995))
PlotSpec(x=s, neutral_losses=tmp)

# provide additional color and annotaion information per peak
PlotSpec(x=s, cols=1+(s[,2]>0.1), txt=data.frame("x"=s[s[,2]>0.1,1],"txt"="txt"))

}

