% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulIVS.R
\name{simulIVS}
\alias{simulIVS}
\title{Simulation of interval-valued responses to a questionnaire}
\usage{
simulIVS(
  n,
  k,
  w1 = 0.05,
  w2 = 0.35,
  w3 = 0.6,
  p = 2,
  q = 2,
  minimum = 1,
  maximum = 7
)
}
\arguments{
\item{n}{a positive integer indicating the number of observations in the questionnaire.}

\item{k}{a single positive integer indicating the number of items in the questionnaire.}

\item{w1}{a single numeric value in \eqn{[0,1]} indicating the proportion of observations that are generated in the first procedure. By default, \code{w1}=0.05.}

\item{w2}{a single numeric value in \eqn{[0,1]} indicating the proportion of observations that are generated in the second procedure. By default, \code{w2}=0.35.}

\item{w3}{a single numeric value in \eqn{[0,1]} indicating the proportion of observations that are generated in the third procedure. By default, \code{w3}=0.60.}

\item{p}{a single positive numeric value indicating the first parameter of a beta distribution. By default, \code{p}=2.}

\item{q}{a positive numeric value indicating the second parameter of the beta distribution. By default, \code{q}=2.}

\item{minimum}{a single numeric value indicating the lower bound of the interval-valued scale used in the questionnaire. By default, \code{minimum}=1.}

\item{maximum}{a single numeric value indicating the upper bound of the interval-valued scale used in the questionnaire. By default, \code{maximum}=7.}
}
\value{
This function returns \eqn{n} interval-valued responses to each of \eqn{k} items in a questionnaire contained in a matrix of dimensions \eqn{n} x \eqn{2k}
with values in the interval \eqn{[\code{minimum}, \code{maximum}]}. All interval-valued data's infimums appear in the first \eqn{k} columns of the matrix and then
appear its corresponding supremums.
}
\description{
This function generates \eqn{n} interval-valued responses to each of \eqn{k} items of a questionnaire.
These interval-valued responses are simulated mimicking the human behavior, considering for it
a finite mixture of three different procedures adapting the ideas of De la Rosa de Saa et al. (2015) and Lubiano et al. (2021).
}
\examples{
data <- simulIVS(100, 5)
head(data)

}
\references{
\itemize{
\item De la Rosa de Saa, S.; Gil, M.A.; Gonzalez-Rodriguez, G.; Lopez, M.T.; Lubiano M.A. (2015). Fuzzy rating scale-based questionnaires and their
statistical analysis, IEEE Transactions on Fuzzy Systems, 23(1):111-126.
\item Lubiano, M.A.; Garcia-Izquierdo, A.L.; Gil, M.A. (2021). Fuzzy rating scales: Does internal consistency of a measurement scale benefit
from coping with imprecision and individual differences in psychological rating? Information Sciences, 550:91-108.
}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es},\cr
with contributions from Asun Lubiano \email{lubiano@uniovi.es}
}
