% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evolution.R
\name{evolution}
\alias{evolution}
\title{Th-U evolution diagram}
\usage{
evolution(x, xlim = NA, ylim = NA, alpha = 0.05, transform = FALSE,
  detrital = FALSE, show.numbers = FALSE, levels = NA,
  ellipse.col = c("#00FF0080", "#FF000080"), line.col = "darksalmon",
  isochron = FALSE, exterr = TRUE, sigdig = 2, ...)
}
\arguments{
\item{x}{an object of class \code{ThU}}

\item{xlim}{x-axis limits}

\item{ylim}{y-axis limits}

\item{alpha}{confidence cutoff for the error ellipses}

\item{transform}{if \code{TRUE}, plots \eqn{^{234}}U/\eqn{^{238}}U
vs. Th-U age.}

\item{detrital}{apply a detrital Th correction by projecting the
compositions along an isochron?}

\item{show.numbers}{label the error ellipses with the grain
numbers?}

\item{levels}{a vector with additional values to be displayed as
different background colours within the error ellipses.}

\item{ellipse.col}{a vector of two background colours for the error
ellipses. If \code{levels=NA}, then only the first colour will
be used. If \code{levels} is a vector of numbers, then
\code{ellipse.col} is used to construct a colour ramp.}

\item{line.col}{colour of the age grid}

\item{isochron}{fit a 3D isochron to the data?}

\item{exterr}{propagate the decay constant uncertainty in the
isochron age?}

\item{sigdig}{number of significant digits for the isochron age}

\item{...}{optional arguments to the generic \code{plot} function}
}
\description{
Plots Th-U data on a
\eqn{^{234}}U/\eqn{^{238}}U-\eqn{^{230}}Th/\eqn{^{238}}U evolution
diagram, a \eqn{^{234}}U/\eqn{^{238}}U-age diagram, or
(if \eqn{^{234}}U/\eqn{^{238}}U is assumed to be in secular equilibrium),
a \eqn{^{230}}Th/\eqn{^{232}}Th-\eqn{^{238}}U/\eqn{^{232}}Th diagram,
calculates isochron ages.
}
\examples{
data(examples)
evolution(examples$ThU)
}
\references{
Ludwig, K.R. and Titterington, D.M., 1994. Calculation
    of \eqn{^{230}}Th/U isochrons, ages, and errors. Geochimica et
    Cosmochimica Acta, 58(22), pp.5031-5042.

Ludwig, K.R., 2003. Mathematical-statistical treatment of data and
    errors for 230 Th/U geochronology. Reviews in Mineralogy and
    Geochemistry, 52(1), pp.631-656.
}
