% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoplotR.R
\docType{package}
\name{IsoplotR}
\alias{IsoplotR}
\alias{_PACKAGE}
\alias{IsoplotR-package}
\alias{IsoplotR-package}
\title{library(IsoplotR)}
\description{
\code{IsoplotR} is a toolkit for isotope geochronology. Plots U-Pb
data on Wetherill and Tera-Wasserburg concordia
diagrams. Calculates concordia and discordia ages. Performs linear
regression of measurements with correlated errors using `York',
`Titterington' and `Ludwig' approaches. Generates Kernel Density
Estimates (KDEs) and Cumulative Age Distributions (CADs). Produces
Multidimensional Scaling (MDS) configurations and Shepard plots of
multi-sample detrital datasets using the Kolmogorov-Smirnov
distance as a dissimilarity measure. Calculates
\eqn{^{40}}Ar/\eqn{^{39}}Ar ages, isochrons, and age
spectra. Computes weighted means accounting for
overdispersion. Calculates U-Th-He (single grain and central) ages,
logratio plots and ternary diagrams. Processes fission track data
using the external detector method and LA-ICP-MS, calculates
central ages and plots fission track and other data on radial
(a.k.a. `Galbraith' plots). Constructs total Pb-U, Pb-Pb, Re-Os,
Sm-Nd, Lu-Hf, Rb-Sr and \eqn{^{230}}Th-U isochrons as well as
\eqn{^{230}}Th-U evolution plots.
}
\details{
A list of documented functions may be viewed by typing
\code{help(package='IsoplotR')}.  Detailed instructions are
provided at \url{http://isoplotr.london-geochron.com}. A manuscript
with the theoretical background is in preparation.
}
\seealso{
Useful links:
\itemize{
  \item \url{http://isoplotr.london-geochron.com}
}

}
\author{
\strong{Maintainer}: Pieter Vermeesch \email{p.vermeesch@ucl.ac.uk}

}
