% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq.R
\name{diseq}
\alias{diseq}
\title{Set up U-series disequilibrium correction for U-Pb
    geochronology}
\usage{
diseq(
  U48 = list(x = 1, sx = 0, option = 0),
  ThU = list(x = 1, sx = 0, option = 0),
  RaU = list(x = 1, sx = 0, option = 0),
  PaU = list(x = 1, sx = 0, option = 0)
)
}
\arguments{
\item{U48}{a list containing three items (\code{x}, \code{sx} and
    \code{option}) specifying the \eqn{{}^{234}}U/\eqn{{}^{238}}U
    disequilibrium.

If \code{option=0}, then \code{x} and \code{sx} are ignored and no
    disequilibrium correction is applied.

If \code{option=1}, then \code{x} contains the initial
    \eqn{{}^{234}}U/\eqn{{}^{238}}U ratio and \code{sx} its
    standard error.

If \code{option=2}, then \code{x} contains the measured
    \eqn{{}^{234}}U/\eqn{{}^{238}}U ratio and \code{sx} its
    standard error.}

\item{ThU}{a list containing three items (\code{x}, \code{sx} and
    \code{option}) specifying the \eqn{{}^{230}}Th/\eqn{{}^{238}}U
    disequilibrium.

If \code{option=0}, then \code{x} and \code{sx} are ignored and no
    disequilibrium correction is applied.

If \code{option=1}, then \code{x} contains the initial
    \eqn{{}^{230}}Th/\eqn{{}^{238}}U ratio and \code{sx} its
    standard error.

If \code{option=2}, then \code{x} contains the measured
    \eqn{{}^{230}}Th/\eqn{{}^{238}}U ratio and \code{sx} its
    standard error.

If \code{option=3}, then \code{x} contains the measured Th/U ratio
    of the magma (assumed or determined from the whole rock or
    volcanic glass) and \code{sx} its standard error. This only
    applies for Th-bearing U-Pb data formats 7 and 8.}

\item{RaU}{a list containing three items (\code{x}, \code{sx} and
    \code{option}) specifying the \eqn{{}^{226}}Ra/\eqn{{}^{238}}U
    disequilibrium.

If \code{option=0}, then \code{x} and \code{sx} are ignored and no
    disequilibrium correction is applied.

If \code{option=1}, then \code{x} contains the initial
    \eqn{{}^{226}}Ra/\eqn{{}^{238}}U ratio and \code{sx} its
    standard error.}

\item{PaU}{a list containing three items (\code{x}, \code{sx} and
    \code{option}) specifying the \eqn{{}^{231}}Pa/\eqn{{}^{235}}U
    disequilibrium.

If \code{option=0}, then \code{x} and \code{sx} are ignored and no
    disequilibrium correction is applied.

If \code{option=1}, then \code{x} contains the initial
    \eqn{{}^{231}}Pa/\eqn{{}^{235}}U ratio and \code{sx} its
    standard error.}
}
\value{
a list with the following items:

\describe{

\item{U48, ThU, RaU, PaU}{the same as the corresponding input arguments}

\item{equilibrium}{a boolean flag indicating whether
\code{option=TRUE} and/or \code{x=1} for all activity ratios}

\item{Q}{the eigenvectors of the disequilibrium matrix exponential}

\item{Qinv}{the inverse of \code{Q}}

\item{L}{a named vector of all the relevant decay constants}

\item{n0}{the initial atomic abundances of all the parent and
daughter isotopes (used by \code{\link{mclean}}). Note that the
\eqn{{}^{238}}U and \eqn{{}^{235}}U decay chains have been
disconnected, so the \eqn{{}^{238}}U/\eqn{{}^{235}}U ratio of
\code{n0} is meaningless.}

}
}
\description{
The U-Pb method conventionally assumes initial secular
    equilibrium of all the intermediate daughters of the
    \eqn{{}^{238}}U-\eqn{{}^{206}}Pb and
    \eqn{{}^{235}}U-\eqn{{}^{207}}Pb decay chains.  Violation of
    this assumption may produce inaccurate results.  \code{diseq}
    sets up initial disequilibrium parameters that are subsequently
    passed on to the \code{read.data} function for incorporation in
    other functions.
}
\details{
There are three ways to correct for the initial disequilibrium
between the activity of \eqn{{}^{238}}U, \eqn{{}^{234}}U,
\eqn{{}^{230}}Th, and \eqn{{}^{226}}Ra; or between \eqn{{}^{235}}U
and \eqn{{}^{231}}Pa:

\enumerate{

\item{Specify the assumed initial activity ratios and calculate how
much excess \eqn{{}^{206}}Pb and \eqn{{}^{207}}Pb these would have
produced.}

\item{Measure the current activity ratios to infer the initial
ratios.  This approach only works for young samples.}

\item{The initial \eqn{{}^{230}}Th/\eqn{{}^{238}}U activity ratio
can also be estimated by providing the Th/U-ratio of the magma.}

}
}
\examples{
d <- diseq(U48=list(x=0,option=1),ThU=list(x=2,option=1),
           RaU=list(x=2,option=1),PaU=list(x=2,option=1))
fn <- system.file("diseq.csv",package="IsoplotR")
UPb <- read.data(fn,method='U-Pb',format=2,d=d)
concordia(UPb,type=2,xlim=c(0,700),ylim=c(0.05,0.5))
}
\seealso{
\code{\link{mclean}}, \code{\link{concordia}},
    \code{\link{ludwig}}
}
