% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-dataset.R
\docType{data}
\name{GNIPDataEUagg}
\alias{GNIPDataEUagg}
\alias{GNIPDataALLagg}
\title{Hydrogen delta values in precipitation water (aggregated per location)}
\format{
The \var{dataframe}s include many observations on the following
variables: \tabular{rlll}{
[, 1] \tab lat \tab (\var{numeric}) \tab Latitude coordinate [decimal degrees]\cr
[, 2] \tab long \tab (\var{numeric}) \tab Longitude coordinate [decimal degrees]\cr
[, 3] \tab elev \tab (\var{numeric}) \tab Elevation asl [m]\cr
[, 4] \tab source_value \tab (\var{numeric}) \tab hydrogen delta value [per thousand]\cr
[, 5] \tab year \tab (\var{numeric}) \tab Year of sampling\cr
[, 6] \tab month \tab (\var{numeric}) \tab Month of sampling\cr
[, 7] \tab source_ID \tab (\var{Factor}) \tab The unique identifier of the weather station\cr }
}
\source{
Data provided by the IAEA and processed by us.
}
\description{
These datasets contain the mean and variance of hydrogen delta value from
precipitation water sampled at weather stations between 1953 and 2015 in
Europe (\code{GNIPDataEUagg}) and in the entire world
(\code{GNIPDataALLagg}). These data have been extracted from the
International Atomic Energy Agency IAEA in Vienna (GNIP Project: Global
Network of Isotopes in Precipitation) and processed by us using the function
\code{\link{prepsources}}. The data are aggregated per location. We no longer
provide the full non-aggregate GNIP dataset in the package as it is not free
to reuse. You can still download the complete GNIP dataset for free, but you
will have to proceed to a registration process with GNIP and use their
downloading interface WISER
(\url{http://www-naweb.iaea.org/napc/ih/IHS_resources_isohis.html}).
}
\details{
These datasets have been aggregated and can thus be directly used for fitting
isoscapes.

If you want to use your own dataset, you must format your data as these
datasets.
}
\examples{

head(GNIPDataALLagg)
dim(GNIPDataALLagg)
head(GNIPDataEUagg)
dim(GNIPDataEUagg)

}
\references{
GNIP Project IAEA Global Network of Isotopes in Precipitation: \url{https://www.iaea.org}
}
\seealso{
\code{\link{GNIPDataDE}} for a non-aggregated dataset.
}
\keyword{datasets}
