% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_issues.R
\name{vgrepl}
\alias{vgrepl}
\title{Vectorize \code{grepl}}
\usage{
vgrepl(
  pattern,
  x,
  ignore.case = TRUE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{pattern}{character string containing a regular expression (or
character string for fixed = TRUE) to be matched in the given character
vector. Coerced by as.character to a character string if possible. Missing
values are allowed except for \code{regexpr}, \code{gregexpr} and
\code{regexec}.}

\item{x}{a character vector where matches are sought, or an object which can
be coerced by as.character to a character vector. Long vectors are supported.}

\item{ignore.case}{logical. if \code{FALSE}, the pattern matching is \emph{case
      sensitive} and if \code{TRUE}, case is ignored during matching.}

\item{perl}{logical.  Should Perl-compatible regexps be used?}

\item{fixed}{logical. If \code{TRUE}, \code{pattern} is a string to be
    matched as is.  Overrides all conflicting arguments.}

\item{useBytes}{logical.  If \code{TRUE} the matching is done
    byte-by-byte rather than character-by-character.  See
    \sQuote{Details}.}
}
\value{
a matrix with as many rows as \code{length(x)} and as many columns
as \code{length(pattern)} containing TRUE or FALSE. Each column is the result
of call to \code{\link[base]{grepl}}.
}
\description{
Vectorize \code{grepl}
}
\details{
This function works the same way as \code{\link[base]{grepl}} but with a
vectorize pattern. This means that if the argument \code{pattern} has a
length >= 2 then the output will be calculated iteratively by pattern. So
instead of having a vector as output, we get a matrix with
\code{length(pattern)} rows and \code{length(pattern)} columns.

For more informations, see the function \code{\link[base]{grepl}}.
}
\keyword{internal}
