% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_functions.R
\name{find_n_feed}
\alias{find_n_feed}
\title{Probability of finding a host and successfully feeding on it}
\usage{
find_n_feed(x, y, a, pref, feed_success)
}
\arguments{
\item{x}{Predictor 1 in transitions table. Numeric vector indicating host
density for each of the host species. Length should be equal to the number
of host species.}

\item{y}{Predictor 2 in transitions table. Not used in this function.}

\item{a}{Parameter \code{a} in parameters table.}

\item{pref}{Parameters named \code{pref} in parameters table. Numeric vector of
length equal to the number of host species. Values are the preference for
ticks in a given transition for each host species.}

\item{feed_success}{Parameters named \verb{feed success} in parameters table.
Numeric vector of length equal to the number of host species. Values are
the feeding success rate for ticks in a given transition while feeding on
each host species.}
}
\value{
Numeric vector of length 1 indicating probability that ticks find any
host and then successfully feed on that host.
}
\description{
Probability of finding a host and successfully feeding on it
}
\examples{
find_n_feed(10, NULL, .1, 1, .5)
find_n_feed(runif(2) * 10, NULL, .1, runif(2), runif(2))

}
