/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import j4r.lang.codetranslator.REnvironment;
import j4r.net.server.AbstractServer;
import j4r.net.server.BasicClient;
import j4r.net.server.ClientThread;
import j4r.net.server.ServerConfiguration;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;

public class JavaLocalGatewayServer
extends AbstractServer {
    public static final String EXTENSION = "-ext";
    public static final String PORT = "-ports";
    public static final String BACKDOORPORT = "-backdoorport";
    public static final String NB_PORTS = "-nbports";
    public static final String WD = "-wd";
    public static final String MEMORY = "-mem";
    public static final String PortSplitter = ":";
    public static final String DEBUG = "-debug";
    protected final ConcurrentHashMap<InetAddress, REnvironment> translators = new ConcurrentHashMap();
    protected final boolean shutdownOnClosedConnection;
    protected boolean bypassShutdownForTesting;

    public JavaLocalGatewayServer(ServerConfiguration servConf, REnvironment translator) throws Exception {
        this(servConf, translator, true);
    }

    synchronized REnvironment registerClient(InetAddress clientAddress) {
        if (!this.translators.containsKey(clientAddress)) {
            this.translators.put(clientAddress, new REnvironment());
        }
        return this.translators.get(clientAddress);
    }

    protected JavaLocalGatewayServer(ServerConfiguration servConf, REnvironment translator, boolean shutdownOnClosedConnection) throws Exception {
        super(servConf, false);
        this.shutdownOnClosedConnection = shutdownOnClosedConnection;
    }

    @Override
    protected ClientThread createClientThread(AbstractServer.CallReceiverThread receiver, int id) {
        return new JavaGatewayClientThread(receiver, id);
    }

    @Override
    protected void shutdown(int shutdownCode) {
        if (this.backdoorThread.isAlive()) {
            this.backdoorThread.softExit();
        }
        if (this.bypassShutdownForTesting) {
            return;
        }
        super.shutdown(shutdownCode);
    }

    @Override
    protected void createFileInfoForLocalServer() throws IOException {
        String filename = String.valueOf(this.getConfiguration().wd.trim()) + File.separator + "J4RTmpFile";
        File file = new File(filename);
        String realizedListeningPorts = "";
        for (AbstractServer.CallReceiverThread t : this.callReceiverThreads) {
            if (!realizedListeningPorts.isEmpty()) {
                realizedListeningPorts = String.valueOf(realizedListeningPorts) + PortSplitter;
            }
            realizedListeningPorts = String.valueOf(realizedListeningPorts) + t.serverSocket.getLocalPort();
        }
        String outputStr = this.getConfiguration().key + ";" + this.backdoorThread.emergencySocket.getLocalPort() + PortSplitter + this.gcReceiverThread.serverSocket.getLocalPort() + ";" + realizedListeningPorts;
        FileWriter writer = new FileWriter(file);
        writer.write(outputStr);
        writer.close();
    }

    private class JavaGatewayClientThread
    extends ClientThread {
        REnvironment translator;

        protected JavaGatewayClientThread(AbstractServer.CallReceiverThread receiver, int workerID) {
            super(receiver, workerID);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    block7: do {
                        JavaLocalGatewayServer.this.firePropertyChange("status", null, "Waiting");
                        this.socketWrapper = this.receiver.clientQueue.take();
                        InetAddress clientAddress = this.socketWrapper.getInetAddress();
                        this.translator = JavaLocalGatewayServer.this.registerClient(clientAddress);
                        JavaLocalGatewayServer.this.whoIsWorkingForWho.put(this, clientAddress);
                        JavaLocalGatewayServer.this.firePropertyChange("status", null, "Connected to client: " + clientAddress.getHostAddress());
                        while (!this.socketWrapper.isClosed()) {
                            try {
                                Object somethingInParticular = this.processRequest();
                                if (somethingInParticular != null) {
                                    if (Thread.interrupted()) {
                                        throw new InterruptedException();
                                    }
                                    if (somethingInParticular.equals((Object)BasicClient.ClientRequest.closeConnection) || somethingInParticular.equals(BasicClient.ClientRequest.closeConnection.name())) {
                                        this.socketWrapper.writeObject((Object)AbstractServer.ServerReply.ClosingConnection);
                                        this.closeSocket();
                                        JavaLocalGatewayServer.this.whoIsWorkingForWho.remove(this);
                                        if (!JavaLocalGatewayServer.this.whoIsWorkingForWho.contains(clientAddress)) {
                                            JavaLocalGatewayServer.this.translators.remove(clientAddress);
                                        }
                                        JavaLocalGatewayServer.this.requestShutdown();
                                        continue block7;
                                    }
                                    this.socketWrapper.writeObject(somethingInParticular);
                                    continue;
                                }
                                this.socketWrapper.writeObject((Object)AbstractServer.ServerReply.Done);
                            }
                            catch (Exception e) {
                                try {
                                    if (e instanceof IOException) {
                                        this.closeSocket();
                                        continue;
                                    }
                                    if (this.socketWrapper.isClosed()) continue;
                                    if (e instanceof InvocationTargetException) {
                                        this.socketWrapper.writeObject(new JavaGatewayException(((InvocationTargetException)e).getTargetException()));
                                        continue;
                                    }
                                    this.socketWrapper.writeObject(new JavaGatewayException((Throwable)e));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    } while (!JavaLocalGatewayServer.this.shutdownOnClosedConnection);
                    JavaLocalGatewayServer.this.requestShutdown();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        @Override
        protected Object processRequest() throws Exception {
            Object crudeRequest = this.getSocket().readObject();
            if (crudeRequest instanceof String) {
                String request = (String)crudeRequest;
                if (BasicClient.ClientRequest.closeConnection.name().equals(request.trim())) {
                    return BasicClient.ClientRequest.closeConnection;
                }
                if (request.startsWith("time")) {
                    long startMillisec = Long.parseLong(request.substring(4));
                    long finalTime = System.currentTimeMillis();
                    double elapsedTime = finalTime - startMillisec;
                    System.out.println("Elapsed time single received packet:" + elapsedTime);
                }
                return this.translator.processCode(request);
            }
            return null;
        }
    }

    final class JavaGatewayException
    extends Exception {
        final Throwable nestedException;

        JavaGatewayException(Throwable e) {
            super(e);
            this.nestedException = e;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getClass().getName()) + "_" + this.nestedException.toString();
        }
    }
}

