% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{default_session}
\alias{default_session}
\title{Create a default session for a custom JBrowse view}
\usage{
default_session(assembly, displayed_tracks, display_assembly = TRUE)
}
\arguments{
\item{assembly}{the config string generated by \code{assembly}}

\item{displayed_tracks}{a vector of tracks generated by a \code{track_*}
command.}

\item{display_assembly}{a boolean determining whether the reference sequence
is visible or not. TRUE by default.}
}
\value{
a character vector of stringified JSON configuration for the
defaultSession to be used by the browser when first loaded
}
\description{
Creates the necessary configuration string for a default session for your
browser. A default session is the set of tracks that are displayed when your
browser is first displayed.
}
\examples{
# create the assembly configuration
assembly <- assembly("https://jbrowse.org/genomes/hg19/fasta/hg19.fa.gz", bgzip = TRUE)

# create variant and wiggle tracks
variant <- track_variant(
 "clinvar.vcf.gz",
 assembly
)
wiggle <- track_wiggle(
 "read-cov.bw",
 assembly
)

# create a default session with those tracks open by default
default_session <- default_session(
 assembly,
 c(variant, wiggle)
)
}
