% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{fr-extract_score}
\alias{fr-extract_score}
\title{Extraction du score}
\arguments{
\item{x}{objet de type \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}.}

\item{format_output}{chaîne de caractères indiquant le format de l'objet en sortie :
soit un \code{data.frame} soit un \code{vector}.}

\item{weighted_score}{booléen indiquant s'il faut extraire le score pondéré (s'il existe) ou le score non pondéré.
Par défaut, c'est le score non pondéré qui est extrait.}
}
\value{
\code{extract_score()} renvoie un data.frame avec deux colonnes : le nom de la série et son score.
}
\description{
Permet d'extraire le score des objets \code{\link{QR_matrix}} ou \code{\link{mQR_matrix}}.
}
\details{
Pour les objets \code{\link{QR_matrix}}, le score renvoyé est soit l'objet \code{NULL} si aucun score n'a été calculé, soit un vecteur.
Pour les objets \code{\link{mQR_matrix}}, c'est une liste de scores (\code{NULL} ou un vecteur).
}
\examples{
# Path of matrix demetra_m
demetra_path <- file.path(
    system.file("extdata", package = "JDCruncheR"),
    "WS/ws_ipi/Output/SAProcessing-1",
    "demetra_m.csv"
)

# Extract the quality report from the demetra_m file
QR <- extract_QR(demetra_path)

# Compute the score
QR1 <- compute_score(QR, n_contrib_score = 2)
mQR <- mQR_matrix(QR, compute_score(QR))

# Extract score
extract_score(QR1)
extract_score(mQR)

}
\keyword{internal}
