% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{set_thresholds}
\alias{set_thresholds}
\title{Set values for thresholds}
\usage{
set_thresholds(test_name, thresholds)
}
\arguments{
\item{test_name}{String. The name of the test to update.}

\item{thresholds}{Named vector of numerics. The upper values of
each break of a threshold.}
}
\description{
Set values for thresholds
}
\details{
If \code{test_name} is missing, the argument \code{thresholds} is not used
and all thresholds will be updated to their default values.

If \code{test_name} is not missing, but if the argument \code{thresholds} is
missing then only the thresholds of the test \code{test_name} will be updated
to its default values.

Finally, if \code{test_name} and \code{thresholds} are not missing, then only
the thresholds of the test \code{test_name} are updated with the value
\code{thresholds}.
}
\examples{

# Set "m7"
set_thresholds(
    test_name = "m7",
    thresholds = c(Good = 0.8, Bad = 1.4, Severe = Inf)
)

# Set "oos_mean" to default
set_thresholds(test_name = "oos_mean")

# Set all thresholds to default
set_thresholds()

}
