/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REngineException;

public abstract class REngine {
    protected static REngine lastEngine = null;

    public static REngine engineForClass(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            throw new ClassNotFoundException("can't find engine class " + string);
        }
        Method method = clazz.getMethod("createEngine", null);
        Object object = method.invoke(null, (Object[])null);
        lastEngine = (REngine)object;
        return lastEngine;
    }

    public static REngine getLastEngine() {
        return lastEngine;
    }

    public abstract REXP eval(String var1, boolean var2) throws REngineException;

    public abstract REXP eval(String var1, REXP[] var2) throws REngineException;

    public abstract void assign(String var1, REXP var2, REXP var3) throws REngineException;

    public abstract REXP get(String var1, REXP var2) throws REngineException;

    public REXP eval(String string) throws REngineException {
        return this.eval(string, true);
    }

    public void voidEval(String string) throws REngineException {
        this.eval(string, false);
    }
}

