/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.Font;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.JGRPrefs;

public class FontTracker {
    public static FontTracker current = null;
    Vector components = new Vector();

    public void add(Component component) {
        component.setFont(JGRPrefs.DefaultFont);
        this.components.add(component);
    }

    public void add(JComponent jComponent) {
        this.add((Component)jComponent);
    }

    public void setFontBigger() {
        Enumeration enumeration = this.components.elements();
        JGRPrefs.FontSize += 2;
        JGRPrefs.refresh();
        this.applyFont();
    }

    public void setFontSmaller() {
        Enumeration enumeration = this.components.elements();
        JGRPrefs.FontSize -= 2;
        JGRPrefs.refresh();
        this.applyFont();
    }

    public void applyFont() {
        Enumeration enumeration = this.components.elements();
        Font font = JGRPrefs.DefaultFont;
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            try {
                Class<?> clazz = component.getClass().getSuperclass();
                while (!clazz.getName().startsWith("java")) {
                    clazz = clazz.getSuperclass();
                }
                if (clazz.getName().equals("javax.swing.JTable")) {
                    if (font.getSize() > 18) {
                        font = new Font(font.getName(), font.getStyle(), 18);
                    }
                    ((JTable)component).setRowHeight((int)((double)font.getSize() * 1.6));
                } else if (!clazz.getName().equals("javax.swing.JTextComponent") && !clazz.getName().equals("javax.swing.JTextPane") && font.getSize() > 18) {
                    font = new Font(font.getName(), font.getStyle(), 18);
                }
                component.setFont(font);
            }
            catch (Exception exception) {}
        }
        if (JGR.R != null && JGR.STARTED) {
            JGR.R.eval("options(width=" + JGR.MAINRCONSOLE.getFontWidth() + ")");
        }
    }
}

