/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.Common;

public class FileSelector
extends JFrame {
    public static final int OPEN = 0;
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    public static String lastDirectory = JGRPrefs.workingDirectory;
    private FileDialog awtDialog = null;
    private JFileChooser swingChooser = null;
    private int type = 0;
    private Frame f;
    private int result = 1;
    private boolean isSwing = false;

    public FileSelector(Frame frame, String string, int n, String string2) {
        this(frame, string, n, string2, false);
    }

    public FileSelector(Frame frame, String string, int n, String string2, boolean bl) {
        this.type = n;
        this.f = frame;
        if (Common.isMac() && !bl) {
            this.awtDialog = new FileDialog(frame, string, n);
            if (string2 != null) {
                this.awtDialog.setDirectory(string2);
            } else if (lastDirectory != null) {
                this.awtDialog.setDirectory(lastDirectory);
            }
            this.isSwing = false;
        } else {
            if (string2 != null) {
                this.swingChooser = new JFileChooser(string2);
            } else if (lastDirectory != null) {
                this.swingChooser = new JFileChooser(lastDirectory);
            }
            this.swingChooser.setDialogTitle(string);
            this.swingChooser.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
            this.isSwing = true;
        }
    }

    public FileSelector(Frame frame, String string, int n) {
        this(frame, string, n, null, false);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.isSwing) {
            this.swingChooser.addActionListener(actionListener);
        }
    }

    public void setVisible(boolean bl) {
        if (!this.isSwing) {
            this.awtDialog.setVisible(true);
        } else {
            this.result = this.type == 0 ? this.swingChooser.showOpenDialog(this.f) : (this.type == 1 ? this.swingChooser.showSaveDialog(this.f) : this.swingChooser.showDialog(this.f, "OK"));
        }
    }

    public String getFile() {
        String string = null;
        try {
            if (!this.isSwing) {
                string = this.awtDialog.getFile();
                lastDirectory = this.awtDialog.getDirectory();
            } else {
                if (this.result == 1) {
                    return null;
                }
                string = this.swingChooser.getSelectedFile().getName();
                lastDirectory = this.swingChooser.getCurrentDirectory().getAbsolutePath() + File.separator;
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getSelectedFile() {
        if (this.isSwing) {
            return this.swingChooser.getSelectedFile();
        }
        return new File(this.awtDialog.getFile());
    }

    public String getDirectory() {
        try {
            if (!this.isSwing) {
                lastDirectory = this.awtDialog.getDirectory();
                return lastDirectory;
            }
            lastDirectory = this.swingChooser.getCurrentDirectory().getAbsolutePath() + File.separator;
            return lastDirectory;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setFile(String string) {
        try {
            if (!this.isSwing) {
                this.awtDialog.setFile(string);
            } else {
                this.swingChooser.setSelectedFile(new File(string));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addFooterPanel(JPanel jPanel) {
        Container container = null;
        try {
            if (this.isSwing) {
                container = System.getProperty("os.name").startsWith("Window") ? (JPanel)((JComponent)((JComponent)this.swingChooser.getComponent(2)).getComponent(2)).getComponent(2) : (JPanel)this.swingChooser.getComponent(this.swingChooser.getComponentCount() - 1);
            }
            if (container != null) {
                container.add(jPanel);
                if (System.getProperty("os.name").startsWith("Window")) {
                    JPanel jPanel2 = (JPanel)((JComponent)((JComponent)this.swingChooser.getComponent(2)).getComponent(2)).getComponent(0);
                    JPanel jPanel3 = new JPanel();
                    jPanel3.setMaximumSize(new Dimension(0, jPanel.getPreferredSize().height));
                    jPanel2.add(jPanel3);
                }
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public boolean isSwing() {
        return this.isSwing;
    }

    public Component getSelector() {
        if (!this.isSwing) {
            return this.awtDialog;
        }
        return this.swingChooser;
    }

    public JFileChooser getJFileChooser() {
        return this.swingChooser;
    }

    public FileDialog getAWTChooser() {
        return this.awtDialog;
    }
}

