/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.rosuda.JGR.toolkit.IconButton;
import org.rosuda.JGR.toolkit.InsertRemoveUndoManager;
import org.rosuda.JGR.toolkit.ProgressLabel;

public class ToolBar
extends JPanel {
    private static final long serialVersionUID = -1556706462420224300L;
    public IconButton newButton;
    public IconButton openButton;
    public IconButton saveButton;
    public IconButton undoButton;
    public IconButton redoButton;
    public IconButton cutButton;
    public IconButton copyButton;
    public IconButton pasteButton;
    public IconButton findButton;
    public IconButton stopButton;
    public IconButton helpButton;
    public InsertRemoveUndoManager undoMgr;

    public ToolBar(ActionListener al) {
        this(al, false, null);
    }

    public ToolBar(ActionListener al, boolean useStopButton) {
        this(al, useStopButton, null);
    }

    public ToolBar(ActionListener al, boolean useStopButton, ProgressLabel progress) {
        this.setLayout(new BorderLayout());
        Dimension bSize = new Dimension(30, 30);
        JPanel b = new JPanel(new FlowLayout(0));
        this.undoMgr = new InsertRemoveUndoManager(al);
        this.newButton = new IconButton("/icons/new.png", "New", al, "new");
        this.openButton = new IconButton("/icons/open.png", "Open", al, "open");
        this.saveButton = new IconButton("/icons/save.png", "Save", al, "save");
        this.undoButton = this.undoMgr.undoButton;
        this.redoButton = this.undoMgr.redoButton;
        this.cutButton = new IconButton("/icons/cut.png", "Cut", al, "cut");
        this.copyButton = new IconButton("/icons/copy.png", "Copy", al, "copy");
        this.pasteButton = new IconButton("/icons/paste.png", "Paste", al, "paste");
        this.findButton = new IconButton("/icons/find.png", "Search", al, "search");
        if (useStopButton) {
            this.stopButton = new IconButton("/icons/stop.png", "Stop", al, "stop");
        }
        this.helpButton = new IconButton("/icons/help.png", "Help", al, "help");
        this.newButton.setMaximumSize(bSize);
        this.openButton.setMaximumSize(bSize);
        this.saveButton.setMaximumSize(bSize);
        this.undoButton.setMaximumSize(bSize);
        this.redoButton.setMaximumSize(bSize);
        this.cutButton.setMaximumSize(bSize);
        this.copyButton.setMaximumSize(bSize);
        this.pasteButton.setMaximumSize(bSize);
        this.findButton.setMaximumSize(bSize);
        this.helpButton.setMaximumSize(bSize);
        this.newButton.setPreferredSize(bSize);
        this.openButton.setPreferredSize(bSize);
        this.saveButton.setPreferredSize(bSize);
        this.undoButton.setPreferredSize(bSize);
        this.redoButton.setPreferredSize(bSize);
        this.cutButton.setPreferredSize(bSize);
        this.copyButton.setPreferredSize(bSize);
        this.pasteButton.setPreferredSize(bSize);
        this.findButton.setPreferredSize(bSize);
        this.helpButton.setPreferredSize(bSize);
        this.newButton.setMinimumSize(bSize);
        this.openButton.setMinimumSize(bSize);
        this.saveButton.setMinimumSize(bSize);
        this.undoButton.setMinimumSize(bSize);
        this.redoButton.setMinimumSize(bSize);
        this.cutButton.setMinimumSize(bSize);
        this.copyButton.setMinimumSize(bSize);
        this.pasteButton.setMinimumSize(bSize);
        this.findButton.setMinimumSize(bSize);
        this.helpButton.setMinimumSize(bSize);
        if (System.getProperty("os.name").startsWith("Window")) {
            this.newButton.setContentAreaFilled(false);
            this.openButton.setContentAreaFilled(false);
            this.saveButton.setContentAreaFilled(false);
            this.undoButton.setContentAreaFilled(false);
            this.redoButton.setContentAreaFilled(false);
            this.cutButton.setContentAreaFilled(false);
            this.copyButton.setContentAreaFilled(false);
            this.pasteButton.setContentAreaFilled(false);
            this.findButton.setContentAreaFilled(false);
            this.helpButton.setContentAreaFilled(false);
        }
        if (useStopButton) {
            this.stopButton.setMaximumSize(bSize);
            this.stopButton.setPreferredSize(bSize);
            this.stopButton.setMinimumSize(bSize);
            if (System.getProperty("os.name").startsWith("Window")) {
                this.stopButton.setContentAreaFilled(false);
            }
        }
        b.add(new Spacer(10));
        b.add(this.newButton);
        b.add(this.openButton);
        b.add(this.saveButton);
        b.add(new Spacer(20));
        b.add(this.undoButton);
        b.add(this.redoButton);
        b.add(new Spacer(20));
        b.add(this.cutButton);
        b.add(this.copyButton);
        b.add(this.pasteButton);
        b.add(new Spacer(20));
        if (useStopButton) {
            b.add(this.stopButton);
        }
        b.add(new Spacer(20));
        b.add(this.findButton);
        b.add(this.helpButton);
        this.add((Component)b, "West");
        if (progress != null) {
            progress.setVisible(true);
            this.add((Component)progress, "East");
        }
    }

    class Spacer
    extends JPanel {
        private static final long serialVersionUID = 7967683127793545620L;

        public Spacer(int width) {
            this.setMinimumSize(new Dimension(width, 0));
            this.setMaximumSize(new Dimension(width, 0));
            this.setPreferredSize(new Dimension(width, 0));
        }
    }
}

