/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.BrowserNodeFactory;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.toolkit.IconButton;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPLogical;

public class DefaultBrowserNode
implements BrowserNode,
BrowserNodeFactory {
    protected String cls;
    protected String rName;
    protected BrowserNode parent;
    protected boolean isList = false;
    protected volatile ArrayList children = new ArrayList();
    protected boolean expanded;
    protected ImageIcon icon;
    protected boolean showSep = false;
    TreeCellRenderer renderer = new DefaultBrowserCellRenderer();

    public DefaultBrowserNode() {
    }

    public DefaultBrowserNode(BrowserNode par, String rObjectName, String rClass) {
        this.parent = par;
        this.rName = rObjectName;
        this.cls = rClass;
        this.icon = this.findIcon();
    }

    protected ImageIcon findIcon() {
        URL url = this.getClass().getResource("/icons/tree_" + this.cls + ".png");
        BufferedImage img = null;
        ImageIcon ic = null;
        try {
            img = ImageIO.read(url);
            ic = new ImageIcon(img);
        }
        catch (Exception e) {
            url = this.getClass().getResource("/icons/tree_default.png");
            img = null;
            try {
                img = ImageIO.read(url);
                ic = new ImageIcon(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ic;
    }

    public Enumeration children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isList;
    }

    @Override
    public TreeNode getChildAt(int i) {
        return (TreeNode)this.children.get(i);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (node != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(MutableTreeNode arg0) {
        this.parent = (BrowserNode)arg0;
    }

    @Override
    public boolean isLeaf() {
        return !this.isList;
    }

    @Override
    public String getRName() {
        return this.rName;
    }

    @Override
    public String getExecuteableRObjectName() {
        if (this.parent == null) {
            return this.rName;
        }
        return this.parent.getChildExecuteableRObjectName(this);
    }

    @Override
    public String getChildExecuteableRObjectName(BrowserNode child) {
        return this.getExecuteableRObjectName() + "[[" + (this.getIndex(child) + 1) + "]]";
    }

    @Override
    public BrowserNode generate(BrowserNode parent, String rName, String rClass) {
        return new DefaultBrowserNode(parent, rName, rClass);
    }

    @Override
    public TreeCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void addChild(BrowserNode node) {
        this.children.add(node);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    @Override
    public void remove(int index) {
        this.children.remove(index);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(this.getIndex(node));
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    @Override
    public void setUserObject(Object arg0) {
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expand) {
        this.expanded = expand;
    }

    @Override
    public void setShowSep(boolean show) {
        this.showSep = show;
    }

    @Override
    public synchronized void update(DefaultTreeModel mod) {
        String fullName = this.parent.getChildExecuteableRObjectName(this);
        try {
            REXP rexp = JGR.idleEval("is.list(" + fullName + ")");
            if (rexp == null) {
                return;
            }
            this.isList = ((REXPLogical)rexp).isTRUE()[0];
            if (!this.expanded) {
                this.children.clear();
                return;
            }
            if (this.isList) {
                boolean[] isNA;
                String[] names;
                rexp = JGR.idleEval("length(" + fullName + ")>0");
                if (rexp == null) {
                    return;
                }
                boolean hasChildren = ((REXPLogical)rexp).isTRUE()[0];
                if (!hasChildren && this.children.size() > 0) {
                    final Object[] tmp = this.children.toArray();
                    final DefaultTreeModel m = mod;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < tmp.length; ++i) {
                                m.removeNodeFromParent((MutableTreeNode)tmp[i]);
                            }
                        }
                    });
                }
                if (!hasChildren) {
                    return;
                }
                REXP nrexp = JGR.idleEval("names(" + fullName + ")");
                if (nrexp == null) {
                    return;
                }
                rexp = JGR.idleEval("sapply(" + fullName + ",function(a)class(a)[1])");
                if (rexp == null) {
                    return;
                }
                String[] objectClasses = rexp.asStrings();
                if (nrexp == null || nrexp.isNull()) {
                    names = new String[objectClasses.length];
                    isNA = new boolean[objectClasses.length];
                    for (int i = 0; i < objectClasses.length; ++i) {
                        names[i] = null;
                        isNA[i] = true;
                    }
                } else {
                    names = nrexp.asStrings();
                    isNA = nrexp.isNA();
                }
                if (names.length < this.children.size()) {
                    final DefaultTreeModel m = mod;
                    final String[] nms = names;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = DefaultBrowserNode.this.children.size() - 1; i >= nms.length; --i) {
                                m.removeNodeFromParent((MutableTreeNode)DefaultBrowserNode.this.children.get(i));
                            }
                        }
                    });
                }
                int nc = Math.min(names.length, BrowserController.MAX_CHILDREN);
                for (int i = 0; i < nc; ++i) {
                    final BrowserNode node = BrowserController.createNode(this, isNA[i] ? null : names[i], objectClasses[i]);
                    if (this.children.size() > i && this.children.get(i).equals(node)) {
                        ((BrowserNode)this.children.get(i)).update(mod);
                        continue;
                    }
                    final Object[] tmp = this.children.toArray();
                    final int j = i;
                    final DefaultTreeModel m = mod;
                    int nChildren = this.children.size();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (tmp.length > j) {
                                for (int ind = j; ind < tmp.length; ++ind) {
                                    m.removeNodeFromParent((MutableTreeNode)tmp[ind]);
                                }
                            }
                            m.insertNodeInto(node, DefaultBrowserNode.this, DefaultBrowserNode.this.children.size());
                        }
                    });
                    node.update(mod);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultBrowserNode)) {
            return false;
        }
        DefaultBrowserNode tmp = (DefaultBrowserNode)obj;
        return (this.cls == null ? tmp.cls == null : this.cls.equals(tmp.cls)) && (this.rName == null ? tmp.rName == null : this.rName.equals(tmp.rName));
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        PopupListener lis = new PopupListener();
        JMenuItem item = new JMenuItem("Edit");
        item.addActionListener(lis);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem("Print");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Summary");
        item.addActionListener(lis);
        item = new JMenuItem("Plot");
        item.addActionListener(lis);
        item = new JMenuItem("Remove");
        item.addActionListener(lis);
        menu.add(item);
        return menu;
    }

    @Override
    public void editObject() {
        try {
            REXP x = JGR.timedEval("suppressWarnings(try(paste(capture.output(dput(" + this.getExecuteableRObjectName() + ")),collapse=\"\n\"),silent=TRUE))");
            if (x != null) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.getExecuteableRObjectName() + "<-");
                sb.append(x.asString());
                Editor ed = new Editor();
                ed.setText(sb);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void printObject() {
        JGR.MAINRCONSOLE.execute("print(" + this.getExecuteableRObjectName() + ")");
    }

    public void summaryObject() {
        JGR.MAINRCONSOLE.execute("summary(" + this.getExecuteableRObjectName() + ")");
    }

    public void plotObject() {
        JGR.MAINRCONSOLE.execute("plot(" + this.getExecuteableRObjectName() + ")");
    }

    @Override
    public void removeChildObjectFromR(BrowserNode node) {
        JGR.MAINRCONSOLE.execute(node.getExecuteableRObjectName() + " <- NULL");
    }

    class DefaultBrowserCellRenderer
    extends DefaultTreeCellRenderer {
        JSeparator sep = new JSeparator(0);
        JPanel pan = new JPanel();
        JPanel subpan = new JPanel();
        JButton but = new IconButton("/icons/advanced_21.png", "", null, "");
        int offset = -1;
        Component rigid;
        int panelWidth = 250;

        public DefaultBrowserCellRenderer() {
            this.pan.setLayout(new BoxLayout(this.pan, 3));
            this.sep.setPreferredSize(new Dimension(5000, 6));
            this.sep.setMaximumSize(new Dimension(5000, 6));
            this.sep.setAlignmentX(0.0f);
            this.setVerticalAlignment(0);
            this.setVerticalTextPosition(0);
            this.subpan.setAlignmentX(0.0f);
            this.subpan.setMinimumSize(new Dimension(0, 20));
            this.pan.removeAll();
            this.pan.setPreferredSize(new Dimension(this.panelWidth, 25));
            this.pan.setSize(new Dimension(this.panelWidth, 25));
            this.pan.setMinimumSize(new Dimension(Short.MAX_VALUE, 30));
            this.pan.setPreferredSize(new Dimension(Short.MAX_VALUE, 30));
            this.pan.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            this.pan.setSize(new Dimension(Short.MAX_VALUE, 30));
            this.pan.add(Box.createVerticalGlue());
            this.pan.add(this.sep);
            this.rigid = Box.createRigidArea(new Dimension(1, 3));
            this.pan.add(this.rigid);
            this.subpan.setLayout(new BoxLayout(this.subpan, 2));
            this.subpan.add(this);
            this.subpan.add(Box.createHorizontalGlue());
            this.but.setSize(21, 21);
            this.subpan.add(this.but);
            this.subpan.setBackground(null);
            this.pan.add(this.subpan);
            this.pan.add(Box.createVerticalGlue());
            this.pan.setBackground(null);
            this.offset = (Integer)UIManager.get("Tree.rightChildIndent") + (Integer)UIManager.get("Tree.leftChildIndent");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (DefaultBrowserNode.this.rName != null) {
                this.setText(DefaultBrowserNode.this.rName);
            } else {
                this.setText("" + (DefaultBrowserNode.this.parent.getIndex(DefaultBrowserNode.this) + 1));
            }
            this.setIcon(DefaultBrowserNode.this.icon);
            this.pan.setToolTipText(DefaultBrowserNode.this.cls);
            this.sep.setVisible(DefaultBrowserNode.this.showSep);
            TreePath tp = tree.getPathForRow(row);
            this.panelWidth = tree.getParent().getWidth() - this.offset * (tp == null ? 1 : tp.getPathCount());
            if (DefaultBrowserNode.this.showSep) {
                this.sep.setSize(new Dimension(this.panelWidth, 6));
                this.sep.setMinimumSize(new Dimension(this.panelWidth, 6));
                this.sep.setPreferredSize(new Dimension(this.panelWidth, 6));
                this.sep.setMaximumSize(new Dimension(this.panelWidth, 6));
            }
            this.subpan.setSize(new Dimension(this.panelWidth, 20));
            this.subpan.setMinimumSize(new Dimension(this.panelWidth, 20));
            this.subpan.setPreferredSize(new Dimension(this.panelWidth, 20));
            this.subpan.setMaximumSize(new Dimension(this.panelWidth, 20));
            this.but.setVisible(selected);
            return this.pan;
        }
    }

    class PopupListener
    implements ActionListener {
        PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            final String cmd = arg0.getActionCommand();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PopupListener.this.runCmd(cmd);
                }
            }).start();
        }

        public void runCmd(String cmd) {
            if (cmd.equals("Edit")) {
                DefaultBrowserNode.this.editObject();
            } else if (cmd.equals("Print")) {
                DefaultBrowserNode.this.printObject();
            } else if (cmd.equals("Summary")) {
                DefaultBrowserNode.this.summaryObject();
            } else if (cmd.equals("Plot")) {
                DefaultBrowserNode.this.plotObject();
            } else if (cmd.equals("Remove")) {
                DefaultBrowserNode.this.parent.removeChildObjectFromR(DefaultBrowserNode.this);
            }
        }
    }
}

