% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apastylr.R
\name{apastylr}
\alias{apastylr}
\title{Creates an APA formatted report from a significance test}
\usage{
apastylr(model, term)
}
\arguments{
\item{model}{A linear model created using \code{lm()}.}

\item{term}{A character string representing a term in the linear model.}
}
\value{
An APA formatted character string.
}
\description{
Create an APA formatted report from the test of a specific term
in a linear model.
}
\examples{

data(ho_et_al)
test <- lm(hypodescent ~ linkedfate, ho_et_al)
apastylr(test, "linkedfate")

}
