% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JUMP.R
\name{JUMP}
\alias{JUMP}
\title{Replicability Analysis of High-Throughput Experiments}
\usage{
JUMP(pvals1, pvals2, alpha = 0.05, lambda = seq(0.01, 0.8, 0.01))
}
\arguments{
\item{pvals1}{A numeric vector of p-values from study 1.}

\item{pvals2}{A numeric vector of p-values from study 2.}

\item{alpha}{The FDR level to control, default is 0.05.}

\item{lambda}{The values of the tuning parameter to estimate pi_0. Must be in [0,1), default is seq(0.01, 0.8, 0.01).}
}
\value{
a list with the following elements:
\item{p.max}{The maximum of p-values across two studies.}
\item{jump.thr}{The estimated threshold of p.max to control FDR at level alpha.}
}
\description{
Replicability Analysis of High-Throughput Experiments
}
\examples{
# Simulate p-values in two studies
m = 10000
h = sample(0:3, m, replace = TRUE, prob = c(0.9, 0.025, 0.025, 0.05))
states1 = rep(0, m); states2 = rep(0, m)
states1[which(h==2|h==3)] = 1; states2[which(h==1|h==3)] = 1
z1 = rnorm(m, states1*2, 1)
z2 = rnorm(m, states2*3, 1)
p1 = 1 - pnorm(z1); p2 = 1 - pnorm(z2)
# Run JUMP to identify replicable signals
res.jump = JUMP(p1, p2, alpha = 0.05)
sig.idx = which(res.jump$p.max <= res.jump$jump.thr)

}
