% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{densplot}
\alias{densplot}
\alias{densplot.JointAI}
\title{Plot posterior density from JointAI model}
\usage{
densplot(object, ...)

\method{densplot}{JointAI}(object, start = NULL, end = NULL, thin = NULL,
  subset = "main", vlines = NULL, nrow = NULL, ncol = NULL, ...)
}
\arguments{
\item{object}{object inheriting from class \code{JointAI}}

\item{...}{additional parameters passed to \code{\link[graphics]{plot}}}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{subset}{subset of monitored parameters (columns in the MCMC sample).
Can be specified as a numeric vector of columns, a vector of
column names, as \code{subset = "main"} or \code{NULL}.
If \code{NULL}, all monitored nodes will be plotted.
\code{subset = "main"} (default) the main parameters of the
analysis model will be plotted (regression coefficients/fixed
effects, and, if available, standard deviation of the residual
and random effects covariance matrix).}

\item{vlines}{list, where each element is a named list of parameters that
can be passed to \code{\link[graphics]{abline}} to create
vertical lines.
Each of the list elements needs to contain at least
\code{v = <x location>}, where <x location> is a vector of the
same length as the number of plots (see examples).}

\item{nrow}{optional; number of rows in the plotting layout
(determined automatically if not specified)}

\item{ncol}{optional; number of columns in the plotting layout
(determined automatically if not specified)}
}
\description{
Plots a set of densities (per MC chain and coefficient) from the MCMC sample
of an object of class JointAI
}
\examples{

mod <- lm_imp(y ~ C1 + C2 + M2, data = wideDF, n.iter = 100)

# densplot without vertical lines
densplot(mod)

# use vlines to mark zero
densplot(mod, col = c("darkred", "darkblue", "darkgreen"),
         vlines = list(list(v = rep(0, nrow(summary(mod)$stats)),
                            col = grey(0.8))))

# use vlines to visualize the posterior mean and 2.5\% and 97.5\% quantiles
densplot(mod, vlines = list(list(v = summary(mod)$stats[, "Mean"], lty = 1, lwd = 2),
                            list(v = summary(mod)$stats[, "2.5\%"], lty = 2),
                            list(v = summary(mod)$stats[, "97.5\%"], lty = 2)))

}
