% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linkedLR.R
\name{linkedLR}
\alias{linkedLR}
\title{LR with pairwise linked markers}
\usage{
linkedLR(
  pedigrees,
  linkageMap,
  linkedPairs = NULL,
  maxdist = Inf,
  markerData = NULL,
  mapfun = "Kosambi",
  lumpSpecial = TRUE
)
}
\arguments{
\item{pedigrees}{A list of two pedigrees.}

\item{linkageMap}{A data frame with columns including \code{Marker}, \code{Chrom} and
\code{PosCM}.}

\item{linkedPairs}{A list of marker pairs. If not supplied, calculated as
\code{getLinkedPairs(markerData$Marker, linkageMap, maxdist = maxdist)}.}

\item{maxdist}{A number, passed onto \code{getLinkedMarkers()} if \code{linkedPairs} is
NULL.}

\item{markerData}{A data frame with marker data, typically the output of
\code{markerSummary(pedigrees)}.}

\item{mapfun}{Name of the map function to be used; either "Haldane" or
"Kosambi" (default).}

\item{lumpSpecial}{A logical, by default TRUE.}
}
\value{
A data frame with detailed LR results.
}
\description{
This function does the main LR calculations of the KLINK app.
}
\examples{
library(forrel)

ped1 = nuclearPed(fa = "AF", child = "CH") |>
  profileSim(markers = NorwegianFrequencies)

ped2 = singletons(c("AF", "CH")) |>
  transferMarkers(from = ped1, to = _)

pedigrees = list(ped1, ped2)

linkedLR(pedigrees, KLINK::LINKAGEMAP)

# For testing
# .linkedLR(pedigrees, markerpair = c("SE33", "D6S474"), linkageMap = LINKAGEMAP)

}
