% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LKM_Int.R
\name{LKM_Int}
\alias{LKM_Int}
\title{KM for Traits by Time Interaction in Longitudinal GWAS Data}
\usage{
LKM_Int(
  phenotype,
  time,
  yid,
  genotypes,
  gid,
  covariates = NULL,
  acc = 1e-04,
  append.write = NULL
)
}
\arguments{
\item{phenotype}{A vector of quantitative trait in the analysis (class: vector). The order should match the vector yid. No missing.}

\item{time}{A vector of time points (class: vector). The order should match the vector yid. No missing.}

\item{yid}{A vector of id (class: vector). Although it doesn't have to be sorted, observations from the same subject have to be connected with each other. The repeated id numbers indicate multiple time points for one subject. Make sure it is not a factor. No missing.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match unique(yid). Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{gid}{A vector of id mapping to samples in genotype file (class: vector). So the order of samples in gid must be the same as the order in genotypes. Make sure it is not a factor. Although gid doesn't have to be in the same order as yid, it is suggested to make them sorted in the same order in order to make all files easily to be tracked. No missing.}

\item{covariates}{A matrix of covariates (class: data.frame). The order of rows should match the vector yid. Default NULL. No missing.}

\item{acc}{Accuracy of numerical integration used in Davies' method. Default 1e-4.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}
}
\value{
output: longitudinal time by marker interaction (LKM_Int) p-value
}
\description{
This function (LKM_Int) is used to perform Kernel Machine analysis for quantitative traits by time interaction in GWAS longitudinal data. \cr
# It considers random intercept and random time
}
\examples{
######################################################################################
### Examples for Marker by Time Interaction in Longitudinal Continuous Traits in GWAS
######################################################################################
###################
# Data using KM ###
###################
data("LKM_numID_int")
pvalue1 <- LKM_Int(phenotype=lkm_int_n_y$y, genotypes=lkm_int_n_gene, time=lkm_int_n_y$time,
yid=lkm_int_n_y$id, gid=lkm_int_n_gid$gid, covariates=NULL)
}
