% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst.each.snp.hudson}
\alias{fst.each.snp.hudson}
\title{Calculate the fixation index (Fst) for all SNPs between two groups of
individuals from Single-nucleotide polymorphism (SNP)}
\usage{
fst.each.snp.hudson(X, idx.p1, idx.p2)
}
\arguments{
\item{X}{A matrix contains the number 0, 1, and 2 representing SNP in
additive coding. Rows represent individuals and columns represent SNP.}

\item{idx.p1}{An integer vector contains the row indices of first population
in the matrix X.}

\item{idx.p2}{An integer vector contains the row indices of second population
in the matrix X.}
}
\value{
The function returns a matrix of pairwise Fst values for all SNPs
between 2 specified groups.
}
\description{
Fixation index (Fst) calculation was implemented using Hudson
method as in Bhatia (2013) and Hudson (1992).
}
\examples{


#Load simulated dataset
data(example_SNP)

idx1 <- which(sample_labels == 'pop1')
idx2 <- which(sample_labels == 'pop2')
fst.pairwise <- fst.each.snp.hudson(simsnp$snp, idx1, idx2)

#Print out the Fst values of the first three SNPs between 'pop1' and 'pop2'
print(fst.pairwise[1:3])

}
\references{
Bhatia, G., Patterson, N., Sankararaman, S., and Price, A.L. (2013).
Estimating and interpreting FST: The impact of rare variants. Genome Res. 23,
1514-1521.

Hudson, R.R., Slatkin, M., and Maddison, W.P. (1992). Estimation of levels of
gene flow from DNA sequence data. Genetics 132, 583-589.
}
\seealso{
\code{\link{fst.hudson}}
}
