/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredDocIdSet;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.lucene.util.Parameter;

public class CachingWrapperFilter
extends Filter {
    protected Filter filter;
    protected final FilterCache cache;
    int hitCount;
    int missCount;
    static /* synthetic */ Class class$org$apache$lucene$search$CachingWrapperFilter;

    public CachingWrapperFilter(Filter filter) {
        this(filter, DeletesMode.IGNORE);
    }

    public CachingWrapperFilter(Filter filter, DeletesMode deletesMode) {
        this.filter = filter;
        this.cache = new FilterCache(deletesMode){

            public Object mergeDeletes(final IndexReader r, Object docIdSet) {
                return new FilteredDocIdSet((DocIdSet)docIdSet){

                    protected boolean match(int docID) {
                        return !r.isDeleted(docID);
                    }
                };
            }
        };
    }

    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bits;
        Object delCoreKey;
        Object coreKey = reader.getFieldCacheKey();
        Object cached = this.cache.get(reader, coreKey, delCoreKey = reader.hasDeletions() ? reader.getDeletesCacheKey() : coreKey);
        if (cached != null) {
            if (cached instanceof BitSet) {
                return (BitSet)cached;
            }
            if (cached instanceof DocIdBitSet) {
                return ((DocIdBitSet)cached).getBitSet();
            }
        }
        if ((bits = this.filter.bits(reader)) != null) {
            this.cache.put(coreKey, delCoreKey, bits);
        }
        return bits;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, IndexReader reader) throws IOException {
        if (docIdSet == null) {
            return DocIdSet.EMPTY_DOCIDSET;
        }
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocIdSet.EMPTY_DOCIDSET : new OpenBitSetDISI(it, reader.maxDoc());
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        Object delCoreKey;
        Object coreKey = reader.getFieldCacheKey();
        Object cached = this.cache.get(reader, coreKey, delCoreKey = reader.hasDeletions() ? reader.getDeletesCacheKey() : coreKey);
        if (cached != null) {
            ++this.hitCount;
            if (cached instanceof DocIdSet) {
                return (DocIdSet)cached;
            }
            return new DocIdBitSet((BitSet)cached);
        }
        ++this.missCount;
        DocIdSet docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(reader), reader);
        if (docIdSet != null) {
            this.cache.put(coreKey, delCoreKey, docIdSet);
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }

    static abstract class FilterCache
    implements Serializable {
        transient Map cache;
        private final DeletesMode deletesMode;
        static final /* synthetic */ boolean $assertionsDisabled;

        public FilterCache(DeletesMode deletesMode) {
            this.deletesMode = deletesMode;
        }

        public synchronized Object get(IndexReader reader, Object coreKey, Object delCoreKey) throws IOException {
            Object value;
            if (this.cache == null) {
                this.cache = new WeakHashMap();
            }
            if (this.deletesMode == DeletesMode.IGNORE) {
                value = this.cache.get(coreKey);
            } else if (this.deletesMode == DeletesMode.RECACHE) {
                value = this.cache.get(delCoreKey);
            } else {
                if (!$assertionsDisabled && this.deletesMode != DeletesMode.DYNAMIC) {
                    throw new AssertionError();
                }
                value = this.cache.get(delCoreKey);
                if (value == null && (value = this.cache.get(coreKey)) != null && reader.hasDeletions()) {
                    value = this.mergeDeletes(reader, value);
                }
            }
            return value;
        }

        protected abstract Object mergeDeletes(IndexReader var1, Object var2);

        public synchronized void put(Object coreKey, Object delCoreKey, Object value) {
            if (this.deletesMode == DeletesMode.IGNORE) {
                this.cache.put(coreKey, value);
            } else if (this.deletesMode == DeletesMode.RECACHE) {
                this.cache.put(delCoreKey, value);
            } else {
                this.cache.put(coreKey, value);
                this.cache.put(delCoreKey, value);
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$search$CachingWrapperFilter == null ? (class$org$apache$lucene$search$CachingWrapperFilter = CachingWrapperFilter.class$("org.apache.lucene.search.CachingWrapperFilter")) : class$org$apache$lucene$search$CachingWrapperFilter).desiredAssertionStatus();
        }
    }

    public static final class DeletesMode
    extends Parameter
    implements Serializable {
        public static DeletesMode IGNORE = new DeletesMode("IGNORE");
        public static DeletesMode RECACHE = new DeletesMode("RECACHE");
        public static DeletesMode DYNAMIC = new DeletesMode("DYNAMIC");

        private DeletesMode(String name) {
            super(name);
        }
    }
}

