% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MdeFunc.R
\name{Koul2StageMde}
\alias{Koul2StageMde}
\title{Two-stage minimum distance estimation in linear regression model with autoregressive error.}
\usage{
Koul2StageMde(Y, X, D, RegIntMeasure, AR_Order, ArIntMeasure)
}
\arguments{
\item{Y}{- Vector of response variables in linear regression model.}

\item{X}{- Design matrix of explanatory variables in linear regression model.}

\item{D}{- Weight matrix. Dimension of D should match that of X. "default" uses XA where A=(X'X)^(-1/2).}

\item{RegIntMeasure}{- Symmetric and \eqn{\sigma}-finite measure used for estimating \eqn{\beta}.}

\item{AR_Order}{- Order of the autoregressive error.}

\item{ArIntMeasure}{- Symmetric and \eqn{\sigma}-finite measure used for estimating autoregressive coefficients of the error.}
}
\value{
MDE1stage - The list of the first stage minimum distance estimation result. It contains betahat1stage, residual1stage, and rhohat1stage.
\itemize{
 \item betahat1stage - The first stage minimum distance estimators of regression coefficients.
 \item residual1stage - Residuals after the first stage minimum distance estimation.
 \item rhohat1stage - The first stage minimum distance estimators of autoregressive coefficients of the error.
}

MDE2stage - The list of the second stage minimum distance estimation result. It contains betahat2stage, residual2stage, and rhohat2stage.
\itemize{
 \item betahat2stage - The second stage minimum distance estimators of regression coefficients.
 \item residual2stage - Residuals after the second stage minimum distance estimation.
 \item rhohat2stage - The second stage minimum distance estimators of autoregressive coefficients of the error.
}
}
\description{
Estimates both regression and autoregressive coefficients in the model \eqn{Y=X\beta + \epsilon} where \eqn{\epsilon} is autoregressive process of known order \code{q}
}
\examples{
####################
n <- 10
p <- 2
X <- matrix(runif(n*p, 0,20), nrow=n, ncol=p)   #### Generate n-by-p design matrix X
beta <- c(-2, 1.5)                        #### Generate true beta = (-2, 1.5)'

q <- 1
rho <- 0.8                            ##### Generate true parameters rho = 0.8
eps <- vector(length=n)
xi <- rnorm(n, 0,1)                            #### Generate innovation from N(0,1)
                                              #### Generate autoregressive process of order q=1
for (i in 1:n){
 tempCol <- rep(0, times=q)
 for (j in 1:q){
   if(i-j<=0){
     tempCol[j] <- 0
   }else{
     tempCol[j] <- eps[i-j]
   }
 }
 eps[i] <- t(tempCol)\%*\% rho + xi[i]
}

Y <- X\%*\%beta + eps
#####################
D <- "default"                                  #### Use the default weight matrix

Lx <- function(x){return(x)}                    ##### Define Lebesgue measure
MDEResult <- Koul2StageMde(Y,X, "default", Lx, q, Lx)
MDE1stageResult <- MDEResult$MDE1stage
MDE2stageResult <- MDEResult$MDE2stage

beta1 <- MDE1stageResult$betahat1stage
residual1 <- MDE1stageResult$residual1stage
rho1 <- MDE1stageResult$rhohat1stage

beta2 <- MDE2stageResult$betahat2stage
residual2 <- MDE2stageResult$residual2stage
rho2 <- MDE2stageResult$rhohat2stage
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde() and KoulLrMde()
}

