% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MdeFunc.R
\name{KoulLrMde}
\alias{KoulLrMde}
\title{Minimum distance estimation in linear regression model.}
\usage{
KoulLrMde(Y, X, D, IntMeasure)
}
\arguments{
\item{Y}{- Vector of response variables in linear regression model.}

\item{X}{- Design matrix of explanatory variables in linear regression model.}

\item{D}{- Weight Matrix. Dimension of D should match that of X. Default value is XA where A=(X'X)^(-1/2).}

\item{IntMeasure}{- Symmetric and \eqn{\sigma}-finite measure.}
}
\value{
betahat   - Minimum distance estimator of \eqn{\beta}.

residual  - Residuals after minimum distance estimation.
}
\description{
Estimates the regression coefficients in the model \eqn{Y=X\beta + \epsilon}.
}
\examples{
####################
n <- 10
p <- 3
X <- matrix(runif(n*p, 0,50), nrow=n, ncol=p)   #### Generate n-by-p design matrix X 
beta <- c(-2, 0.3, 1.5)                        #### Generate true beta = (-2, 0.3, 1.5)' 
eps <- rnorm(n, 0,1)                           #### Generate errors from N(0,1)
Y <- X\%*\%beta + eps

D <- "default"                                 #### Use the default weight matrix

Lx <- "Lebesgue"                               ##### Define Lebesgue measure 
MDEResult <- KoulLrMde(Y,X,D, Lx)              ##### Use Lebesgue measure for the integration
betahat <- MDEResult$betahat                   ##### Obtain minimum distance estimator 
resid <- MDEResult$residual                    ##### Obtain residual 

Dx <- "Degenerate"                             ##### Define degenerate measure at 0
MDEResult <- KoulLrMde(Y,X,D, Dx)              ##### Use degenerate measure at 0 for the integration
betahat <- MDEResult$betahat                   ##### Obtain minimum distance estimator 
resid <- MDEResult$residual                    ##### Obtain residual
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde() and Koul2StageMde()
}

