% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OA2LHD.R
\name{OA2LHD}
\alias{OA2LHD}
\title{Transfer an Orthogonal Array (OA) into a LHD}
\usage{
OA2LHD(OA, n, m, s, r)
}
\arguments{
\item{OA}{A Matrix.}

\item{n}{A positive integer.}

\item{m}{A positive integer.}

\item{s}{A positive integer.}

\item{r}{A positive integer.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{m} LHD.
}
\description{
\code{OA2LHD} transfers an OA into a LHD with corresponding size
}
\details{
\itemize{
\item \code{OA} stands for the input orthogonal array matrix.
\item \code{n} stands for the number of rows of OA.
\item \code{m} stands for the number of columns of OA.
\item \code{s} stands for the number of levels of OA.
\item \code{r} stands for the strength of OA.
}
}
\note{
LHD(n,m)=OA(n,m,n,1)
}
\examples{
#create an OA(9,2,3,2)
OA=matrix(c(rep(1:3,each=3),rep(1:3,times=3)),ncol=2,nrow=9,byrow = FALSE);OA

#Transfer the "OA" above into a LHD according to Tang (1993)
tryOA=OA2LHD(OA=OA,9,2,3,2)
OA;tryOA
}
\references{
Tang, B. (1993) Orthogonal-array-based latin hypercubes. \emph{Journal of the Americal Statistical Association}, \strong{88}, 1392-1397.
}
