% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLM_chat_session.R
\name{llm_chat_session}
\alias{llm_chat_session}
\alias{chat_session}
\alias{as.data.frame.llm_chat_session}
\alias{summary.llm_chat_session}
\alias{head.llm_chat_session}
\alias{tail.llm_chat_session}
\alias{print.llm_chat_session}
\title{Stateful chat session constructor}
\usage{
chat_session(config, system = NULL, ...)

\method{as.data.frame}{llm_chat_session}(x, ...)

\method{summary}{llm_chat_session}(object, ...)

\method{head}{llm_chat_session}(x, n = 6L, width = getOption("width") - 15, ...)

\method{tail}{llm_chat_session}(x, n = 6L, width = getOption("width") - 15, ...)

\method{print}{llm_chat_session}(x, width = getOption("width") - 15, ...)
}
\arguments{
\item{config}{An \code{\link{llm_config}} \strong{for a generative model}
(i.e. \code{embedding = FALSE}).}

\item{system}{Optional system prompt inserted once at the beginning.}

\item{...}{Arguments passed to other methods. For \code{chat_session}, these
are default arguments forwarded to every
\code{\link{call_llm_robust}} call (e.g.
\code{verbose = TRUE}, \code{json = TRUE}).}

\item{x, object}{An \code{llm_chat_session} object.}

\item{n}{Number of turns to display.}

\item{width}{Character width for truncating long messages.}
}
\value{
For \code{chat_session()}, an object of class \strong{\code{llm_chat_session}}.
For other methods, the return value is described by their respective titles.
}
\description{
Stateful chat session constructor

Coerce a chat session to a data frame

Summary statistics for a chat session

Display the first part of a chat session

Display the last part of a chat session

Print a chat session object
}
\details{
The \code{chat_session} object provides a simple way to hold a conversation with
a generative model. It wraps \code{\link{call_llm_robust}} to benefit from
retry logic, caching, and error logging.
}
\section{How it works}{

\enumerate{
\item A private environment stores the running list of
\code{list(role, content)} messages.
\item At each \code{$send()} the history is sent \emph{in full} to the model.
\item Provider-agnostic token counts are extracted from the JSON response
(fields are detected by name, so new providers continue to work).
}
}

\section{Public methods}{

\describe{
\item{\code{$send(text, ..., role = "user")}}{
Append a message (default role \code{"user"}), query the model,
print the assistant’s reply, and invisibly return it.}
\item{\code{$history()}}{Raw list of messages.}
\item{\code{$history_df()}}{Two-column data frame (\code{role},
\code{content}).}
\item{\code{$tokens_sent()}/\code{$tokens_received()}}{Running token
totals.}
\item{\code{$reset()}}{Clear history (retains the optional system
message).}
}
}

\examples{
\dontrun{
cfg  <- llm_config("openai", "gpt-4o-mini", Sys.getenv("OPENAI_API_KEY"))
chat <- chat_session(cfg, system = "Be concise.")
chat$send("Who invented the moon?")
chat$send("Explain why in one short sentence.")

# Using S3 methods
chat           # print() shows a summary and first 10 turns
summary(chat)  # Get session statistics
tail(chat, 2)  # See the last 2 turns of the conversation
df <- as.data.frame(chat) # Convert the full history to a data frame
}
}
\seealso{
\code{\link{llm_config}} to create the configuration object.
\code{\link{call_llm_robust}} for single, stateless API calls.
\code{\link{llm_fn}} for applying a prompt to many items in a vector or data frame.
}
